/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.deployments;

import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentList;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesDeploymentsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesDeploymentsProducer.class);

    public KubernetesDeploymentsProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listDeployments": {
                this.doList(exchange, operation);
                break;
            }
            case "listDeploymentsByLabels": {
                this.doListDeploymentsByLabels(exchange, operation);
                break;
            }
            case "getDeployment": {
                this.doGetDeployment(exchange, operation);
                break;
            }
            case "deleteDeployment": {
                this.doDeleteDeployment(exchange, operation);
                break;
            }
            case "createDeployment": {
                this.doCreateDeployment(exchange, operation);
                break;
            }
            case "scaleDeployment": {
                this.doScaleDeployment(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String operation) throws Exception {
        DeploymentList deploymentsList = (DeploymentList)this.getEndpoint().getKubernetesClient().extensions().deployments().list();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)deploymentsList.getItems());
    }

    protected void doListDeploymentsByLabels(Exchange exchange, String operation) throws Exception {
        DeploymentList deploymentList = null;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesDeploymentsLabels", Map.class);
        MixedOperation deployments = this.getEndpoint().getKubernetesClient().extensions().deployments();
        for (Map.Entry entry : labels.entrySet()) {
            deployments.withLabel((String)entry.getKey(), (String)entry.getValue());
        }
        deploymentList = (DeploymentList)deployments.list();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)deploymentList.getItems());
    }

    protected void doGetDeployment(Exchange exchange, String operation) throws Exception {
        Deployment deployment = null;
        String deploymentName = (String)exchange.getIn().getHeader("CamelKubernetesDeploymentName", String.class);
        if (ObjectHelper.isEmpty((Object)deploymentName)) {
            LOG.error("Get a specific Deployment require specify a Deployment name");
            throw new IllegalArgumentException("Get a specific Deployment require specify a Deployment name");
        }
        deployment = (Deployment)((ScalableResource)this.getEndpoint().getKubernetesClient().extensions().deployments().withName(deploymentName)).get();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)deployment);
    }

    protected void doDeleteDeployment(Exchange exchange, String operation) {
        String deploymentName = (String)exchange.getIn().getHeader("CamelKubernetesDeploymentName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)deploymentName)) {
            LOG.error("Delete a specific deployment require specify a deployment name");
            throw new IllegalArgumentException("Delete a specific deployment require specify a deployment name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Delete a specific deployment require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific deployment require specify a namespace name");
        }
        Boolean deployment = (Boolean)((ScalableResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().extensions().deployments().inNamespace(namespaceName)).withName(deploymentName)).delete();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)deployment);
    }

    protected void doCreateDeployment(Exchange exchange, String operation) throws Exception {
        Deployment deployment = null;
        String deploymentName = (String)exchange.getIn().getHeader("CamelKubernetesDeploymentName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        DeploymentSpec deSpec = (DeploymentSpec)exchange.getIn().getHeader("CamelKubernetesDeploymentSpec", DeploymentSpec.class);
        if (ObjectHelper.isEmpty((Object)deploymentName)) {
            LOG.error("Create a specific Deployment require specify a Deployment name");
            throw new IllegalArgumentException("Create a specific pod require specify a pod name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Create a specific pod require specify a namespace name");
            throw new IllegalArgumentException("Create a specific pod require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)deSpec)) {
            LOG.error("Create a specific Deployment require specify a Deployment spec bean");
            throw new IllegalArgumentException("Create a specific Deployment require specify a Deployment spec bean");
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesDeploymentsLabels", Map.class);
        Deployment deploymentCreating = ((DeploymentBuilder)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(deploymentName)).withLabels(labels)).endMetadata()).withSpec(deSpec)).build();
        deployment = (Deployment)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().extensions().deployments().inNamespace(namespaceName)).create((Object[])new Deployment[]{deploymentCreating});
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)deployment);
    }

    protected void doScaleDeployment(Exchange exchange, String operation) throws Exception {
        String deploymentName = (String)exchange.getIn().getHeader("CamelKubernetesDeploymentName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        Integer replicasNumber = (Integer)exchange.getIn().getHeader("CamelKubernetesDeploymentReplicas", Integer.class);
        if (ObjectHelper.isEmpty((Object)deploymentName)) {
            LOG.error("Scale a specific deployment require specify a deployment name");
            throw new IllegalArgumentException("Scale a specific deployment require specify a deployment name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Scale a specific deployment require specify a namespace name");
            throw new IllegalArgumentException("Scale a specific deployment require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)replicasNumber)) {
            LOG.error("Scale a specific deployment require specify a replicas number");
            throw new IllegalArgumentException("Scale a specific deployment require specify a replicas number");
        }
        Deployment deploymentScaled = (Deployment)((ScalableResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().extensions().deployments().inNamespace(namespaceName)).withName(deploymentName)).scale(replicasNumber.intValue(), false);
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)deploymentScaled.getStatus().getReplicas());
    }
}

