/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fop;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.fop.FopEndpoint;
import org.apache.camel.component.fop.FopOutputType;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.pdf.PDFEncryptionParams;

public class FopProducer
extends DefaultProducer {
    private final FopFactory fopFactory;
    private final String outputFormat;

    public FopProducer(FopEndpoint endpoint, FopFactory fopFactory, String outputFormat) {
        super((Endpoint)endpoint);
        this.fopFactory = fopFactory;
        this.outputFormat = outputFormat;
    }

    public void process(Exchange exchange) throws Exception {
        FOUserAgent userAgent = this.fopFactory.newFOUserAgent();
        Map headers = exchange.getIn().getHeaders();
        this.setRenderParameters(userAgent, headers);
        this.setEncryptionParameters(userAgent, headers);
        this.setUserAgentRendererOptions(userAgent, headers);
        String outputFormat = this.getOutputFormat(exchange);
        Source src = (Source)exchange.getIn().getBody(StreamSource.class);
        OutputStream out = this.transform(userAgent, outputFormat, src);
        exchange.getOut().setBody((Object)out);
        exchange.getOut().setHeaders(headers);
    }

    private String getOutputFormat(Exchange exchange) {
        String headerOutputFormat = (String)exchange.getIn().getHeader("CamelFop.Output.Format", String.class);
        if (headerOutputFormat != null) {
            FopOutputType type = (FopOutputType)((Object)exchange.getContext().getTypeConverter().tryConvertTo(FopOutputType.class, exchange, (Object)headerOutputFormat));
            if (type != null) {
                return type.getFormatExtended();
            }
            return headerOutputFormat;
        }
        return this.outputFormat;
    }

    private OutputStream transform(FOUserAgent userAgent, String outputFormat, Source src) throws FOPException, TransformerException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Fop fop = this.fopFactory.newFop(outputFormat, userAgent, (OutputStream)out);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        SAXResult res = new SAXResult(fop.getDefaultHandler());
        transformer.transform(src, res);
        return out;
    }

    private void setEncryptionParameters(FOUserAgent userAgent, Map<String, Object> headers) throws Exception {
        Map encryptionParameters = IntrospectionSupport.extractProperties(headers, (String)"CamelFop.Encrypt.");
        if (!encryptionParameters.isEmpty()) {
            PDFEncryptionParams encryptionParams = new PDFEncryptionParams();
            IntrospectionSupport.setProperties((Object)encryptionParams, (Map)encryptionParameters);
            userAgent.getRendererOptions().put("encryption-params", encryptionParams);
        }
    }

    private void setUserAgentRendererOptions(FOUserAgent userAgent, Map<String, Object> headers) {
        Map parameters = IntrospectionSupport.extractProperties(headers, (String)"CamelFop.RendererOptions.");
        if (!parameters.isEmpty()) {
            userAgent.getRendererOptions().putAll(parameters);
        }
    }

    private void setRenderParameters(FOUserAgent userAgent, Map<String, Object> headers) throws Exception {
        Map parameters = IntrospectionSupport.extractProperties(headers, (String)"CamelFop.Render.");
        if (!parameters.isEmpty()) {
            IntrospectionSupport.setProperties((Object)userAgent, (Map)parameters);
        }
    }
}

