/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentracing.starter;

import io.opentracing.Tracer;
import org.apache.camel.CamelContext;
import org.apache.camel.opentracing.OpenTracingTracer;
import org.apache.camel.opentracing.starter.OpenTracingConfigurationProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={OpenTracingConfigurationProperties.class})
@ConditionalOnProperty(value={"camel.opentracing.enabled"}, matchIfMissing=true)
public class OpenTracingAutoConfiguration {
    @Autowired(required=false)
    private Tracer tracer;

    @Bean(initMethod="", destroyMethod="")
    @ConditionalOnMissingBean(value={OpenTracingTracer.class})
    OpenTracingTracer openTracingEventNotifier(CamelContext camelContext, OpenTracingConfigurationProperties config) {
        OpenTracingTracer ottracer = new OpenTracingTracer();
        if (this.tracer != null) {
            ottracer.setTracer(this.tracer);
        }
        if (config.getExcludePatterns() != null) {
            ottracer.setExcludePatterns(config.getExcludePatterns());
        }
        ottracer.init(camelContext);
        return ottracer;
    }
}

