/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.yql;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.yql.YqlEndpoint;
import org.apache.camel.component.yql.configuration.YqlConfiguration;
import org.apache.camel.component.yql.configuration.YqlConfigurationValidator;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.Metadata;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class YqlComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private HttpClientConnectionManager localConnectionManager;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        YqlConfiguration configuration = new YqlConfiguration();
        configuration.setQuery(remaining);
        this.setProperties(configuration, parameters);
        YqlConfigurationValidator.validateProperties(configuration);
        HttpClientConnectionManager connectionManager = this.createConnectionManager();
        return new YqlEndpoint(uri, this, configuration, connectionManager);
    }

    protected void doStop() throws Exception {
        if (this.localConnectionManager != null) {
            this.localConnectionManager.shutdown();
        }
    }

    public HttpClientConnectionManager getLocalConnectionManager() {
        return this.localConnectionManager;
    }

    public void setConnectionManager(HttpClientConnectionManager connectionManager) {
        this.localConnectionManager = connectionManager;
    }

    private HttpClientConnectionManager createConnectionManager() {
        if (this.localConnectionManager != null) {
            return this.localConnectionManager;
        }
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultMaxPerRoute(20);
        this.setConnectionManager((HttpClientConnectionManager)connectionManager);
        return connectionManager;
    }
}

