/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ignite.queue;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ignite.AbstractIgniteEndpoint;
import org.apache.camel.component.ignite.IgniteComponent;
import org.apache.camel.component.ignite.queue.IgniteQueueComponent;
import org.apache.camel.component.ignite.queue.IgniteQueueOperation;
import org.apache.camel.component.ignite.queue.IgniteQueueProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.ignite.IgniteQueue;
import org.apache.ignite.configuration.CollectionConfiguration;

@UriEndpoint(firstVersion="2.17.0", scheme="ignite-queue", title="Ignite Queues", syntax="ignite-queue:name", label="nosql,cache", producerOnly=true)
public class IgniteQueueEndpoint
extends AbstractIgniteEndpoint {
    @UriPath
    @Metadata(required="true")
    private String name;
    @UriParam(label="producer")
    private int capacity;
    @UriParam(label="producer")
    private CollectionConfiguration configuration = new CollectionConfiguration();
    @UriParam(label="producer")
    private Long timeoutMillis;
    @UriParam(label="producer")
    private IgniteQueueOperation operation;

    @Deprecated
    public IgniteQueueEndpoint(String endpointUri, URI remainingUri, Map<String, Object> parameters, IgniteComponent igniteComponent) throws Exception {
        super(endpointUri, (Component)igniteComponent);
        this.name = remainingUri.getHost();
        ObjectHelper.notNull((Object)this.name, (String)"Queue name");
        if (!parameters.containsKey("configuration")) {
            Map configProps = IntrospectionSupport.extractProperties(parameters, (String)"config.");
            EndpointHelper.setReferenceProperties((CamelContext)this.getCamelContext(), (Object)configProps, parameters);
            EndpointHelper.setProperties((CamelContext)this.getCamelContext(), (Object)configProps, parameters);
        }
    }

    public IgniteQueueEndpoint(String endpointUri, String remaining, Map<String, Object> parameters, IgniteQueueComponent igniteComponent) throws Exception {
        super(endpointUri, (Component)igniteComponent);
        this.name = remaining;
        ObjectHelper.notNull((Object)this.name, (String)"Queue name");
        if (!parameters.containsKey("configuration")) {
            Map configProps = IntrospectionSupport.extractProperties(parameters, (String)"config.");
            EndpointHelper.setReferenceProperties((CamelContext)this.getCamelContext(), (Object)configProps, parameters);
            EndpointHelper.setProperties((CamelContext)this.getCamelContext(), (Object)configProps, parameters);
        }
    }

    public Producer createProducer() throws Exception {
        IgniteQueue queue = this.ignite().queue(this.name, this.capacity, this.configuration);
        return new IgniteQueueProducer(this, (IgniteQueue<Object>)queue);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("The Ignite Queue endpoint doesn't support consumers.");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IgniteQueueOperation getOperation() {
        return this.operation;
    }

    public void setOperation(IgniteQueueOperation operation) {
        this.operation = operation;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public CollectionConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CollectionConfiguration configuration) {
        this.configuration = configuration;
    }

    public Long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void setTimeoutMillis(Long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }
}

