/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.blob;

import com.microsoft.azure.storage.blob.CloudBlob;
import java.util.Map;
import org.apache.camel.component.azure.blob.BlobServiceOperations;
import org.apache.camel.component.azure.blob.BlobType;
import org.apache.camel.component.azure.common.AbstractConfiguration;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class BlobServiceConfiguration
extends AbstractConfiguration {
    private String containerName;
    private String blobName;
    @UriParam
    private CloudBlob azureBlobClient;
    @UriParam(defaultValue="blockblob")
    private BlobType blobType = BlobType.blockblob;
    @UriParam(label="producer", defaultValue="listBlobs")
    private BlobServiceOperations operation = BlobServiceOperations.listBlobs;
    @UriParam(label="producer")
    private int streamWriteSize;
    @UriParam
    private int streamReadSize;
    @UriParam(label="producer")
    private Map<String, String> blobMetadata;
    @UriParam(defaultValue="true")
    private boolean closeStreamAfterRead = true;
    @UriParam(label="producer", defaultValue="true")
    private boolean closeStreamAfterWrite = true;
    @UriParam
    private String fileDir;
    @UriParam(defaultValue="0")
    private Long blobOffset = 0L;
    @UriParam
    private Long dataLength;
    @UriParam(label="producer")
    private String blobPrefix;
    @UriParam
    private boolean publicForRead;
    @UriParam(label="producer", defaultValue="true")
    private boolean useFlatListing = true;

    public BlobServiceOperations getOperation() {
        return this.operation;
    }

    public void setOperation(BlobServiceOperations operation) {
        this.operation = operation;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public String getBlobName() {
        return this.blobName;
    }

    public void setBlobName(String blobName) {
        this.blobName = blobName;
    }

    public BlobType getBlobType() {
        return this.blobType;
    }

    public void setBlobType(BlobType blobType) {
        this.blobType = blobType;
    }

    public int getStreamWriteSize() {
        return this.streamWriteSize;
    }

    public void setStreamWriteSize(int streamWriteSize) {
        this.streamWriteSize = streamWriteSize;
    }

    public int getStreamReadSize() {
        return this.streamReadSize;
    }

    public void setStreamReadSize(int streamReadSize) {
        this.streamReadSize = streamReadSize;
    }

    public Map<String, String> getBlobMetadata() {
        return this.blobMetadata;
    }

    public void setBlobMetadata(Map<String, String> blobMetadata) {
        this.blobMetadata = blobMetadata;
    }

    public CloudBlob getAzureBlobClient() {
        return this.azureBlobClient;
    }

    public void setAzureBlobClient(CloudBlob azureBlobClient) {
        this.azureBlobClient = azureBlobClient;
    }

    public boolean isCloseStreamAfterWrite() {
        return this.closeStreamAfterWrite;
    }

    public void setCloseStreamAfterWrite(boolean closeStreamAfterWrite) {
        this.closeStreamAfterWrite = closeStreamAfterWrite;
    }

    public boolean isCloseStreamAfterRead() {
        return this.closeStreamAfterRead;
    }

    public void setCloseStreamAfterRead(boolean closeStreamAfterRead) {
        this.closeStreamAfterRead = closeStreamAfterRead;
    }

    public String getFileDir() {
        return this.fileDir;
    }

    public void setFileDir(String fileDir) {
        this.fileDir = fileDir;
    }

    public Long getBlobOffset() {
        return this.blobOffset;
    }

    public void setBlobOffset(Long dataOffset) {
        this.blobOffset = dataOffset;
    }

    public Long getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(Long dataLength) {
        this.dataLength = dataLength;
    }

    public String getBlobPrefix() {
        return this.blobPrefix;
    }

    public void setBlobPrefix(String blobPrefix) {
        this.blobPrefix = blobPrefix;
    }

    public boolean isPublicForRead() {
        return this.publicForRead;
    }

    public void setPublicForRead(boolean publicForRead) {
        this.publicForRead = publicForRead;
    }

    public boolean isUseFlatListing() {
        return this.useFlatListing;
    }

    public void setUseFlatListing(boolean useFlatListing) {
        this.useFlatListing = useFlatListing;
    }
}

