/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.processor.aggregate;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultExchangeHolder;
import org.apache.camel.spi.RecoverableAggregationRepository;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.DefaultCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanLocalAggregationRepository
extends ServiceSupport
implements RecoverableAggregationRepository {
    private static final Logger LOG = LoggerFactory.getLogger((String)InfinispanLocalAggregationRepository.class.getName());
    private boolean useRecovery = true;
    private DefaultCacheManager manager;
    private String cacheName;
    private String deadLetterChannel;
    private long recoveryInterval = 5000L;
    private int maximumRedeliveries = 3;
    private boolean allowSerializedHeaders;
    private BasicCache<String, DefaultExchangeHolder> cache;
    private Configuration configuration;

    public InfinispanLocalAggregationRepository() {
    }

    public InfinispanLocalAggregationRepository(String cacheName) {
        this.cacheName = cacheName;
    }

    public Exchange add(CamelContext camelContext, String key, Exchange exchange) {
        LOG.trace("Adding an Exchange with ID {} for key {} in a thread-safe manner.", (Object)exchange.getExchangeId(), (Object)key);
        DefaultExchangeHolder newHolder = DefaultExchangeHolder.marshal((Exchange)exchange, (boolean)true, (boolean)this.allowSerializedHeaders);
        DefaultExchangeHolder oldHolder = (DefaultExchangeHolder)this.cache.put((Object)key, (Object)newHolder);
        return this.unmarshallExchange(camelContext, oldHolder);
    }

    public Exchange get(CamelContext camelContext, String key) {
        return this.unmarshallExchange(camelContext, (DefaultExchangeHolder)this.cache.get((Object)key));
    }

    public void remove(CamelContext camelContext, String key, Exchange exchange) {
        LOG.trace("Removing an exchange with ID {} for key {} ", (Object)exchange.getExchangeId(), (Object)key);
        this.cache.remove((Object)key);
    }

    public void confirm(CamelContext camelContext, String exchangeId) {
        LOG.trace("Confirming an exchange with ID {}.", (Object)exchangeId);
        this.cache.remove((Object)exchangeId);
    }

    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.cache.keySet());
    }

    public Set<String> scan(CamelContext camelContext) {
        LOG.trace("Scanning for exchanges to recover in {} context", (Object)camelContext.getName());
        Set<String> scanned = Collections.unmodifiableSet(this.cache.keySet());
        LOG.trace("Found {} keys for exchanges to recover in {} context", (Object)scanned.size(), (Object)camelContext.getName());
        return scanned;
    }

    public Exchange recover(CamelContext camelContext, String exchangeId) {
        LOG.trace("Recovering an Exchange with ID {}.", (Object)exchangeId);
        return this.useRecovery ? this.unmarshallExchange(camelContext, (DefaultExchangeHolder)this.cache.get((Object)exchangeId)) : null;
    }

    public void setRecoveryInterval(long interval, TimeUnit timeUnit) {
        this.recoveryInterval = timeUnit.toMillis(interval);
    }

    public void setRecoveryInterval(long interval) {
        this.recoveryInterval = interval;
    }

    public long getRecoveryIntervalInMillis() {
        return this.recoveryInterval;
    }

    public void setUseRecovery(boolean useRecovery) {
        this.useRecovery = useRecovery;
    }

    public boolean isUseRecovery() {
        return this.useRecovery;
    }

    public void setDeadLetterUri(String deadLetterUri) {
        this.deadLetterChannel = deadLetterUri;
    }

    public String getDeadLetterUri() {
        return this.deadLetterChannel;
    }

    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public int getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    protected void doStart() throws Exception {
        if (this.maximumRedeliveries < 0) {
            throw new IllegalArgumentException("Maximum redelivery retries must be zero or a positive integer.");
        }
        if (this.recoveryInterval < 0L) {
            throw new IllegalArgumentException("Recovery interval must be zero or a positive integer.");
        }
        if (ObjectHelper.isEmpty((Object)this.configuration)) {
            this.manager = new DefaultCacheManager();
            this.manager.start();
        } else {
            this.manager = new DefaultCacheManager(this.configuration);
            this.manager.start();
        }
        this.cache = ObjectHelper.isEmpty((Object)this.cacheName) ? this.manager.getCache() : this.manager.getCache(this.cacheName);
    }

    protected void doStop() throws Exception {
        this.manager.stop();
    }

    protected Exchange unmarshallExchange(CamelContext camelContext, DefaultExchangeHolder holder) {
        DefaultExchange exchange = null;
        if (holder != null) {
            exchange = new DefaultExchange(camelContext);
            DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)holder);
        }
        return exchange;
    }

    public DefaultCacheManager getManager() {
        return this.manager;
    }

    public void setManager(DefaultCacheManager manager) {
        this.manager = manager;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public String getDeadLetterChannel() {
        return this.deadLetterChannel;
    }

    public void setDeadLetterChannel(String deadLetterChannel) {
        this.deadLetterChannel = deadLetterChannel;
    }

    public boolean isAllowSerializedHeaders() {
        return this.allowSerializedHeaders;
    }

    public void setAllowSerializedHeaders(boolean allowSerializedHeaders) {
        this.allowSerializedHeaders = allowSerializedHeaders;
    }

    public BasicCache<String, DefaultExchangeHolder> getCache() {
        return this.cache;
    }

    public void setCache(BasicCache<String, DefaultExchangeHolder> cache) {
        this.cache = cache;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

