/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.csv;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.bindy.BindyAbstractDataFormat;
import org.apache.camel.dataformat.bindy.BindyAbstractFactory;
import org.apache.camel.dataformat.bindy.BindyCsvFactory;
import org.apache.camel.dataformat.bindy.FormatFactory;
import org.apache.camel.dataformat.bindy.util.ConverterUtils;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindyCsvDataFormat
extends BindyAbstractDataFormat {
    private static final Logger LOG = LoggerFactory.getLogger(BindyCsvDataFormat.class);

    public BindyCsvDataFormat() {
    }

    public BindyCsvDataFormat(Class<?> type) {
        super(type);
    }

    public String getDataFormatName() {
        return "bindy-csv";
    }

    public void marshal(Exchange exchange, Object body, OutputStream outputStream) throws Exception {
        BindyCsvFactory factory = (BindyCsvFactory)this.getFactory();
        ObjectHelper.notNull((Object)factory, (String)"not instantiated");
        byte[] bytesCRLF = ConverterUtils.getByteReturn(factory.getCarriageReturn());
        if (factory.getGenerateHeaderColumnNames()) {
            String result = factory.generateHeader();
            byte[] bytes = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, exchange, (Object)result);
            outputStream.write(bytes);
            outputStream.write(bytesCRLF);
        }
        ArrayList<Map> models = new ArrayList<Map>();
        Iterator it = ObjectHelper.createIterator((Object)body);
        while (it.hasNext()) {
            Object model = it.next();
            if (model instanceof Map) {
                models.add((Map)model);
                continue;
            }
            String name = model.getClass().getName();
            HashMap<String, Object> row = new HashMap<String, Object>(1);
            row.put(name, model);
            row.putAll(this.createLinkedFieldsModel(model));
            models.add(row);
        }
        Iterator modelsMap = models.iterator();
        while (modelsMap.hasNext()) {
            String result = factory.unbind(this.getCamelContext(), (Map)modelsMap.next());
            byte[] bytes = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, exchange, (Object)result);
            outputStream.write(bytes);
            if (!factory.isEndWithLineBreak() && !modelsMap.hasNext()) continue;
            outputStream.write(bytesCRLF);
        }
    }

    private boolean checkEmptyStream(BindyCsvFactory factory, InputStream inputStream) throws IOException {
        boolean allowEmptyStream = factory.isAllowEmptyStream();
        boolean isStreamEmpty = false;
        boolean canReturnEmptyListOfModels = false;
        if (inputStream == null || inputStream.available() == 0) {
            isStreamEmpty = true;
        }
        if (isStreamEmpty && allowEmptyStream) {
            canReturnEmptyListOfModels = true;
        }
        return canReturnEmptyListOfModels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        Object object;
        block16: {
            Scanner scanner;
            InputStreamReader in;
            ArrayList<Map<String, Object>> models;
            BindyCsvFactory factory;
            block14: {
                ArrayList<Map<String, Object>> arrayList;
                block15: {
                    factory = (BindyCsvFactory)this.getFactory();
                    ObjectHelper.notNull((Object)factory, (String)"not instantiated");
                    models = new ArrayList<Map<String, Object>>();
                    in = null;
                    scanner = null;
                    if (!this.checkEmptyStream(factory, inputStream)) break block14;
                    arrayList = models;
                    if (scanner != null) {
                        scanner.close();
                    }
                    if (in == null) break block15;
                    IOHelper.close((Closeable)in, (String)"in", (Logger)LOG);
                }
                return arrayList;
            }
            try {
                in = new InputStreamReader(inputStream, IOHelper.getCharsetName((Exchange)exchange));
                scanner = new Scanner(in);
                String separator = factory.getSeparator();
                String quote = factory.getQuote();
                ObjectHelper.notNull((Object)separator, (String)"The separator has not been defined in the annotation @CsvRecord or not instantiated during initModel.");
                int count = 0;
                if (factory.getSkipFirstLine() && scanner.hasNextLine()) {
                    scanner.nextLine();
                }
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine().trim();
                    if (ObjectHelper.isEmpty((Object)line)) continue;
                    ++count;
                    Map<String, Object> model = factory.factory();
                    Pattern pattern = Pattern.compile(separator);
                    Matcher matcher = pattern.matcher(line);
                    ArrayList<String> separators = new ArrayList<String>();
                    while (matcher.find()) {
                        separators.add(matcher.group());
                    }
                    if (separators.size() > 0) {
                        separators.add((String)separators.get(separators.size() - 1));
                    }
                    String[] tokens = pattern.split(line, factory.getAutospanLine() ? factory.getMaxpos() : -1);
                    List<String> result = Arrays.asList(tokens);
                    if ((result = this.unquoteTokens(result, separators, quote)).size() == 0 || result.isEmpty()) {
                        throw new IllegalArgumentException("No records have been defined in the CSV");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Size of the record splitted : {}", (Object)result.size());
                    }
                    factory.bind(this.getCamelContext(), result, model, count);
                    factory.link(model);
                    models.add(model);
                    LOG.debug("Graph of objects created: {}", model);
                }
                if (models.size() == 0) {
                    throw new IllegalArgumentException("No records have been defined in the CSV");
                }
                object = this.extractUnmarshalResult(models);
                if (scanner != null) {
                    scanner.close();
                }
                if (in == null) break block16;
            }
            catch (Throwable throwable) {
                if (scanner != null) {
                    scanner.close();
                }
                if (in != null) {
                    IOHelper.close(in, (String)"in", (Logger)LOG);
                }
                throw throwable;
            }
            IOHelper.close((Closeable)in, (String)"in", (Logger)LOG);
        }
        return object;
    }

    private List<String> unquoteTokens(List<String> result, List<String> separators, String quote) {
        StringBuilder current = new StringBuilder();
        boolean inProgress = false;
        ArrayList<String> answer = new ArrayList<String>();
        int idxSeparator = 0;
        for (String s : result) {
            boolean canStart = false;
            boolean canClose = false;
            boolean cutStart = false;
            boolean cutEnd = false;
            if (s.startsWith(quote)) {
                if (s.length() == 1) {
                    s = "";
                    if (inProgress) {
                        canClose = true;
                    } else {
                        canStart = true;
                    }
                } else {
                    cutStart = true;
                    canStart = true;
                }
            }
            if (s.endsWith(quote)) {
                cutEnd = true;
                canClose = true;
            }
            if (cutEnd || cutStart) {
                s = s.substring(cutStart ? 1 : 0, cutEnd ? s.length() - 1 : s.length());
            }
            if (inProgress) {
                current.append(separators.get(idxSeparator));
                current.append(s);
                if (canClose) {
                    answer.add(current.toString());
                    current.setLength(0);
                    inProgress = false;
                }
            } else if (canStart && !canClose) {
                current.append(s);
                inProgress = true;
            } else {
                answer.add(s);
            }
            ++idxSeparator;
        }
        if (current.length() > 0) {
            answer.add(current.toString());
            current.setLength(0);
        }
        return answer;
    }

    @Override
    protected BindyAbstractFactory createModelFactory(FormatFactory formatFactory) throws Exception {
        BindyCsvFactory bindyCsvFactory = new BindyCsvFactory(this.getClassType());
        bindyCsvFactory.setFormatFactory(formatFactory);
        return bindyCsvFactory;
    }
}

