/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.thoughtworks.xstream.MarshallingStrategy;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.TreeMarshallingStrategy;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.naming.NoNameCoder;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.api.NoSuchSObjectException;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.AnnotationFieldKeySorter;
import org.apache.camel.component.salesforce.api.dto.RestError;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectBatch;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectBatchResponse;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectComposite;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectCompositeResponse;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectTree;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectTreeResponse;
import org.apache.camel.component.salesforce.api.utils.DateTimeConverter;
import org.apache.camel.component.salesforce.api.utils.JsonUtils;
import org.apache.camel.component.salesforce.api.utils.Version;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.AbstractClientBase;
import org.apache.camel.component.salesforce.internal.client.CompositeApiClient;
import org.apache.camel.component.salesforce.internal.client.XStreamUtils;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCompositeApiClient
extends AbstractClientBase
implements CompositeApiClient {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCompositeApiClient.class);
    private static final XStream NO_XSTREAM = null;
    private final PayloadFormat format;
    private ObjectMapper mapper;
    private final Map<Class<?>, ObjectReader> readers = new HashMap();
    private final Map<Class<?>, ObjectWriter> writters = new HashMap();
    private final XStream xStreamCompositeBatch;
    private final XStream xStreamCompositeTree;

    public DefaultCompositeApiClient(SalesforceEndpointConfig configuration, PayloadFormat format, String version, SalesforceSession session, SalesforceHttpClient httpClient) throws SalesforceException {
        super(version, session, httpClient);
        this.format = format;
        this.mapper = configuration.getObjectMapper() != null ? configuration.getObjectMapper() : JsonUtils.createObjectMapper();
        this.xStreamCompositeBatch = DefaultCompositeApiClient.configureXStream(SObjectBatch.class, SObjectBatchResponse.class);
        this.xStreamCompositeTree = DefaultCompositeApiClient.configureXStream(SObjectTree.class, SObjectTreeResponse.class);
        this.xStreamCompositeTree.alias("SObjectTreeResponse", SObjectTreeResponse.class);
    }

    @Override
    public void submitComposite(SObjectComposite composite, Map<String, List<String>> headers, CompositeApiClient.ResponseCallback<SObjectCompositeResponse> callback) throws SalesforceException {
        DefaultCompositeApiClient.checkCompositeFormat(this.format, SObjectComposite.REQUIRED_PAYLOAD_FORMAT);
        String url = this.versionUrl() + "composite";
        Request post = this.createRequest(HttpMethod.POST, url, headers);
        ContentProvider content = this.serialize(NO_XSTREAM, composite, composite.objectTypes());
        post.content(content);
        this.doHttpRequest(post, (response, responseHeaders, exception) -> callback.onResponse(this.tryToReadResponse(NO_XSTREAM, SObjectCompositeResponse.class, response), responseHeaders, exception));
    }

    @Override
    public void submitCompositeBatch(SObjectBatch batch, Map<String, List<String>> headers, CompositeApiClient.ResponseCallback<SObjectBatchResponse> callback) throws SalesforceException {
        DefaultCompositeApiClient.checkCompositeBatchVersion(this.version, batch.getVersion());
        String url = this.versionUrl() + "composite/batch";
        Request post = this.createRequest(HttpMethod.POST, url, headers);
        ContentProvider content = this.serialize(this.xStreamCompositeBatch, batch, batch.objectTypes());
        post.content(content);
        this.doHttpRequest(post, (response, responseHeaders, exception) -> callback.onResponse(this.tryToReadResponse(this.xStreamCompositeBatch, SObjectBatchResponse.class, response), responseHeaders, exception));
    }

    @Override
    public void submitCompositeTree(SObjectTree tree, Map<String, List<String>> headers, CompositeApiClient.ResponseCallback<SObjectTreeResponse> callback) throws SalesforceException {
        String url = this.versionUrl() + "composite/tree/" + tree.getObjectType();
        Request post = this.createRequest(HttpMethod.POST, url, headers);
        ContentProvider content = this.serialize(this.xStreamCompositeTree, tree, tree.objectTypes());
        post.content(content);
        this.doHttpRequest(post, (response, responseHeaders, exception) -> callback.onResponse(this.tryToReadResponse(this.xStreamCompositeTree, SObjectTreeResponse.class, response), responseHeaders, exception));
    }

    Request createRequest(HttpMethod method, String url, Map<String, List<String>> headers) {
        Request request = this.getRequest(method, url, headers);
        this.setAccessToken(request);
        if (this.format == PayloadFormat.JSON) {
            request.header(HttpHeader.CONTENT_TYPE, "application/json;charset=utf-8");
            request.header(HttpHeader.ACCEPT, "application/json;charset=utf-8");
        } else {
            request.header(HttpHeader.CONTENT_TYPE, "application/xml;charset=utf-8");
            request.header(HttpHeader.ACCEPT, "application/xml;charset=utf-8");
        }
        request.header(HttpHeader.ACCEPT_CHARSET, "utf-8");
        return request;
    }

    <T> T fromJson(Class<T> expectedType, InputStream responseStream) throws IOException {
        return (T)this.jsonReaderFor(expectedType).readValue(responseStream);
    }

    ObjectReader jsonReaderFor(Class<?> type) {
        return Optional.ofNullable(this.readers.get(type)).orElseGet(() -> this.mapper.readerFor(type));
    }

    ObjectWriter jsonWriterFor(Object obj) {
        Class<?> type = obj.getClass();
        return Optional.ofNullable(this.writters.get(type)).orElseGet(() -> this.mapper.writerFor(type));
    }

    ContentProvider serialize(XStream xstream, Object body, Class<?> ... additionalTypes) throws SalesforceException {
        if (this.format == PayloadFormat.JSON) {
            return new InputStreamContentProvider(this.toJson(body));
        }
        xstream.processAnnotations((Class[])additionalTypes);
        return new InputStreamContentProvider(DefaultCompositeApiClient.toXml(xstream, body));
    }

    String servicesDataUrl() {
        return this.instanceUrl + "/services/data/";
    }

    InputStream toJson(Object obj) throws SalesforceException {
        byte[] jsonBytes;
        try {
            jsonBytes = this.jsonWriterFor(obj).writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            throw new SalesforceException("Unable to serialize given SObjectTree to JSON", e);
        }
        return new ByteArrayInputStream(jsonBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Optional<T> tryToReadResponse(XStream xstream, Class<T> expectedType, InputStream responseStream) {
        if (responseStream == null) {
            return Optional.empty();
        }
        try {
            if (this.format == PayloadFormat.JSON) {
                Optional<T> optional = Optional.of(this.fromJson(expectedType, responseStream));
                return optional;
            }
            Optional<T> optional = Optional.of(DefaultCompositeApiClient.fromXml(xstream, responseStream));
            return optional;
        }
        catch (XStreamException | IOException e) {
            LOG.warn("Unable to read response from the Composite API", e);
            Optional optional = Optional.empty();
            return optional;
        }
        finally {
            IOHelper.close((Closeable)responseStream);
        }
    }

    String versionUrl() {
        ObjectHelper.notNull((Object)this.version, (String)"version");
        return this.servicesDataUrl() + "v" + this.version + "/";
    }

    @Override
    protected SalesforceException createRestException(Response response, InputStream responseContent) {
        List<RestError> errors;
        try {
            errors = this.readErrorsFrom(responseContent, this.format, this.mapper, this.xStreamCompositeTree);
        }
        catch (IOException e) {
            return new SalesforceException("Unable to read error response", e);
        }
        int status = response.getStatus();
        if (status == 404) {
            return new NoSuchSObjectException(errors);
        }
        String reason = response.getReason();
        return new SalesforceException("Unexpected error: " + reason, status);
    }

    @Override
    protected void setAccessToken(Request request) {
        request.getHeaders().put("Authorization", "Bearer " + this.accessToken);
    }

    static void checkCompositeBatchVersion(String configuredVersion, Version batchVersion) throws SalesforceException {
        if (Version.create(configuredVersion).compareTo(batchVersion) < 0) {
            throw new SalesforceException("Component is configured with Salesforce API version " + configuredVersion + ", but the payload of the Composite API batch operation requires at least " + batchVersion, 0);
        }
    }

    static void checkCompositeFormat(PayloadFormat configuredFormat, PayloadFormat requiredFormat) throws SalesforceException {
        if (configuredFormat != requiredFormat) {
            throw new SalesforceException("Component is configured with Salesforce Composite API format " + (Object)((Object)configuredFormat) + ", but the payload of the Composite API operation requires format " + (Object)((Object)requiredFormat), 0);
        }
    }

    static XStream configureXStream(Class<?> ... additionalTypes) {
        PureJavaReflectionProvider reflectionProvider = new PureJavaReflectionProvider(new FieldDictionary((FieldKeySorter)new AnnotationFieldKeySorter()));
        XppDriver hierarchicalStreamDriver = new XppDriver((NameCoder)new NoNameCoder()){

            public HierarchicalStreamWriter createWriter(Writer out) {
                return new CompactWriter(out, this.getNameCoder());
            }
        };
        XStream xStream = new XStream((ReflectionProvider)reflectionProvider, (HierarchicalStreamDriver)hierarchicalStreamDriver);
        xStream.aliasSystemAttribute(null, "class");
        xStream.ignoreUnknownElements();
        XStreamUtils.addDefaultPermissions(xStream);
        xStream.registerConverter((Converter)new DateTimeConverter());
        xStream.setMarshallingStrategy((MarshallingStrategy)new TreeMarshallingStrategy());
        xStream.processAnnotations((Class[])additionalTypes);
        return xStream;
    }

    static <T> T fromXml(XStream xstream, InputStream responseStream) {
        Object read = xstream.fromXML(responseStream);
        return (T)read;
    }

    static InputStream toXml(XStream xstream, Object obj) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        xstream.toXML(obj, (OutputStream)out);
        return new ByteArrayInputStream(out.toByteArray());
    }
}

