/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow.releases.helsinki;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.servicenow.AbstractServiceNowProcessor;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.component.servicenow.ServiceNowParams;

class HelsinkiServiceNowServiceCatalogCartsProcessor
extends AbstractServiceNowProcessor {
    HelsinkiServiceNowServiceCatalogCartsProcessor(ServiceNowEndpoint endpoint) throws Exception {
        super(endpoint);
        this.addDispatcher("retrieve", "delivery_address", this::retrieveDeliveryAddress);
        this.addDispatcher("retrieve", "checkout", this::retrieveCheckoutCart);
        this.addDispatcher("retrieve", "checkout", this::retrieveCarts);
        this.addDispatcher("update", "checkout", this::checkoutCart);
        this.addDispatcher("update", this::updateCart);
        this.addDispatcher("delete", this::deleteCart);
    }

    private void retrieveCarts(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Class<?> responseModel = this.getResponseModel(in);
        String apiVersion = this.getApiVersion(in);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("sn_sc").path(apiVersion).path("servicecatalog").path("cart").query(responseModel).invoke("GET");
        this.setBodyAndHeaders(in, responseModel, response);
    }

    private void retrieveDeliveryAddress(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Class<?> responseModel = this.getResponseModel(in);
        String apiVersion = this.getApiVersion(in);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("sn_sc").path(apiVersion).path("servicecatalog").path("cart").path("delivery_address").path(this.getMandatoryRequestParamFromHeader(ServiceNowParams.PARAM_USER_ID, in)).query(responseModel).invoke("GET");
        this.setBodyAndHeaders(in, responseModel, response);
    }

    private void updateCart(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Class<?> responseModel = this.getResponseModel(in);
        String apiVersion = this.getApiVersion(in);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("sn_sc").path(apiVersion).path("servicecatalog").path("cart").path(this.getMandatoryRequestParamFromHeader(ServiceNowParams.PARAM_CART_ITEM_ID, in)).query(responseModel).invoke("POST", in.getMandatoryBody());
        this.setBodyAndHeaders(in, responseModel, response);
    }

    private void deleteCart(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Class<?> responseModel = this.getResponseModel(in);
        String apiVersion = this.getApiVersion(in);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("sn_sc").path(apiVersion).path("servicecatalog").path("cart").path(this.getMandatoryRequestParamFromHeader(ServiceNowParams.PARAM_SYS_ID, in)).path("empty").query(responseModel).invoke("DELETE");
        this.setBodyAndHeaders(in, responseModel, response);
    }

    private void retrieveCheckoutCart(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Class<?> responseModel = this.getResponseModel(in);
        String apiVersion = this.getApiVersion(in);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("sn_sc").path(apiVersion).path("servicecatalog").path("cart").path("checkout").query(responseModel).invoke("POST");
        this.setBodyAndHeaders(in, responseModel, response);
    }

    private void checkoutCart(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Class<?> responseModel = this.getResponseModel(in);
        String apiVersion = this.getApiVersion(in);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("sn_sc").path(apiVersion).path("servicecatalog").path("cart").path("submit_order").query(responseModel).invoke("POST");
        this.setBodyAndHeaders(in, responseModel, response);
    }
}

