/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client;

import java.util.Objects;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.milo.NamespaceId;
import org.apache.camel.component.milo.PartialNodeId;
import org.apache.camel.component.milo.client.MiloClientComponent;
import org.apache.camel.component.milo.client.MiloClientConfiguration;
import org.apache.camel.component.milo.client.MiloClientConnection;
import org.apache.camel.component.milo.client.MiloClientConsumer;
import org.apache.camel.component.milo.client.MiloClientItemConfiguration;
import org.apache.camel.component.milo.client.MiloClientProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;

@UriEndpoint(firstVersion="2.19.0", scheme="milo-client", syntax="milo-client:endpointUri", title="OPC UA Client", consumerClass=MiloClientConsumer.class, label="iot")
public class MiloClientEndpoint
extends DefaultEndpoint
implements MiloClientItemConfiguration {
    @UriPath
    @Metadata(required="true")
    private final String endpointUri;
    @UriParam
    private ExpandedNodeId node;
    @UriParam
    private Double samplingInterval;
    @UriParam
    private MiloClientConfiguration client;
    @UriParam
    private boolean defaultAwaitWrites;
    private final MiloClientConnection connection;
    private final MiloClientComponent component;

    public MiloClientEndpoint(String uri, MiloClientComponent component, MiloClientConnection connection, String endpointUri) {
        super(uri, (Component)component);
        Objects.requireNonNull(component);
        Objects.requireNonNull(connection);
        Objects.requireNonNull(endpointUri);
        this.endpointUri = endpointUri;
        this.component = component;
        this.connection = connection;
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.component.disposed(this);
        super.doStop();
    }

    public Producer createProducer() throws Exception {
        return new MiloClientProducer((Endpoint)this, this.connection, this, this.defaultAwaitWrites);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new MiloClientConsumer(this, processor, this.connection, this);
    }

    public boolean isSingleton() {
        return true;
    }

    public MiloClientConnection getConnection() {
        return this.connection;
    }

    @Override
    public PartialNodeId makePartialNodeId() {
        PartialNodeId result = null;
        if (this.node != null) {
            result = PartialNodeId.fromExpandedNodeId(this.node);
        }
        if (result == null) {
            throw new IllegalStateException("Missing or invalid node id configuration");
        }
        return result;
    }

    @Override
    public NamespaceId makeNamespaceId() {
        NamespaceId result = null;
        if (this.node != null) {
            result = NamespaceId.fromExpandedNodeId(this.node);
        }
        if (result == null) {
            throw new IllegalStateException("Missing or invalid node id configuration");
        }
        return result;
    }

    public void setNode(String node) {
        this.node = node == null ? null : ExpandedNodeId.parse((String)node);
    }

    public String getNode() {
        if (this.node != null) {
            return this.node.toParseableString();
        }
        return null;
    }

    @Override
    public Double getSamplingInterval() {
        return this.samplingInterval;
    }

    public void setSamplingInterval(Double samplingInterval) {
        this.samplingInterval = samplingInterval;
    }

    public boolean isDefaultAwaitWrites() {
        return this.defaultAwaitWrites;
    }

    public void setDefaultAwaitWrites(boolean defaultAwaitWrites) {
        this.defaultAwaitWrites = defaultAwaitWrites;
    }
}

