/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ical;

import java.io.InputStream;
import java.io.OutputStream;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;

public class ICalDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private CalendarOutputter outputer = new CalendarOutputter();
    private CalendarBuilder builder = new CalendarBuilder();

    public String getDataFormatName() {
        return "ical";
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        Calendar calendar = (Calendar)exchange.getContext().getTypeConverter().convertTo(Calendar.class, graph);
        this.outputer.output(calendar, stream);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return this.builder.build(stream);
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    public void setValidating(boolean validate) {
        this.outputer.setValidating(validate);
    }

    public boolean isValidating() {
        return this.outputer.isValidating();
    }

    public CalendarOutputter getOutputer() {
        return this.outputer;
    }

    public void setOutputer(CalendarOutputter outputer) {
        this.outputer = outputer;
    }

    public CalendarBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(CalendarBuilder builder) {
        this.builder = builder;
    }
}

