/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.master;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.master.MasterComponent;
import org.apache.camel.component.master.MasterConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;

@ManagedResource(description="Managed Master Endpoint")
@UriEndpoint(firstVersion="2.20.0", scheme="master", syntax="master:namespace:delegateUri", consumerClass=MasterConsumer.class, consumerOnly=true, title="Master", lenientProperties=true, label="clustering")
public class MasterEndpoint
extends DefaultEndpoint
implements DelegateEndpoint {
    private final Endpoint delegateEndpoint;
    @UriPath(description="The name of the cluster namespace to use")
    @Metadata(required="true")
    private final String namespace;
    @UriPath(description="The endpoint uri to use in master/slave mode")
    @Metadata(required="true")
    private final String delegateUri;
    private final CamelClusterService clusterService;

    public MasterEndpoint(String uri, MasterComponent component, CamelClusterService clusterService, String namespace, String delegateUri) {
        super(uri, (Component)component);
        this.clusterService = clusterService;
        this.namespace = namespace;
        this.delegateUri = delegateUri;
        this.delegateEndpoint = this.getCamelContext().getEndpoint(delegateUri);
    }

    public Producer createProducer() throws Exception {
        this.getComponent();
        throw new UnsupportedOperationException("Cannot produce from this endpoint");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new MasterConsumer(this, processor, this.clusterService);
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isLenientProperties() {
        return true;
    }

    @ManagedAttribute(description="The consumer endpoint url to use in master/slave mode", mask=true)
    public Endpoint getEndpoint() {
        return this.delegateEndpoint;
    }

    @ManagedAttribute(description="The name of the cluster namespace/group to use")
    public String getNamespace() {
        return this.namespace;
    }
}

