/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc.server;

import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.component.grpc.GrpcConsumer;
import org.apache.camel.component.grpc.GrpcEndpoint;
import org.apache.camel.component.grpc.server.GrpcRequestAbstractStreamObserver;

public class GrpcRequestPropagationStreamObserver
extends GrpcRequestAbstractStreamObserver {
    public GrpcRequestPropagationStreamObserver(GrpcEndpoint endpoint, GrpcConsumer consumer, StreamObserver<Object> responseObserver, Map<String, Object> headers) {
        super(endpoint, consumer, responseObserver, headers);
    }

    public void onNext(Object request) {
        CountDownLatch latch = new CountDownLatch(1);
        Object responseBody = null;
        this.exchange = this.endpoint.createExchange();
        this.exchange.getIn().setBody(request);
        this.exchange.getIn().setHeaders(this.headers);
        this.consumer.process(this.exchange, doneSync -> latch.countDown());
        try {
            latch.await();
            responseBody = this.exchange.hasOut() ? this.exchange.getOut().getBody() : this.exchange.getIn().getBody();
            if (responseBody instanceof List) {
                List responseList = (List)responseBody;
                responseList.forEach(responseItem -> this.responseObserver.onNext(responseItem));
            } else {
                this.responseObserver.onNext(responseBody);
            }
            this.responseObserver.onCompleted();
        }
        catch (InterruptedException e) {
            this.responseObserver.onError((Throwable)e);
        }
    }

    public void onError(Throwable throwable) {
        this.exchange = this.endpoint.createExchange();
        this.exchange.getIn().setHeaders(this.headers);
        this.consumer.onError(this.exchange, throwable);
        this.responseObserver.onError(throwable);
    }

    public void onCompleted() {
        this.exchange = this.endpoint.createExchange();
        this.exchange.getIn().setHeaders(this.headers);
        this.consumer.onCompleted(this.exchange);
        this.responseObserver.onCompleted();
    }
}

