/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.swift.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.common.AbstractOpenstackProducer;
import org.apache.camel.component.openstack.swift.SwiftEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.common.Payload;
import org.openstack4j.model.storage.object.SwiftObject;
import org.openstack4j.model.storage.object.options.ObjectLocation;

public class ObjectProducer
extends AbstractOpenstackProducer {
    public ObjectProducer(SwiftEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            case "getMetadata": {
                this.doGetMetadata(exchange);
                break;
            }
            case "createUpdateMetadata": {
                this.doUpdateMetadata(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        Message msg = exchange.getIn();
        Payload payload = this.createPayload(msg);
        String containerName = (String)msg.getHeader("containerName", String.class);
        String objectName = (String)msg.getHeader("objectName", String.class);
        ObjectHelper.notEmpty((String)containerName, (String)"Container name");
        ObjectHelper.notEmpty((String)objectName, (String)"Object name");
        String etag = this.os.objectStorage().objects().put(containerName, objectName, payload);
        msg.setBody((Object)etag);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String containerName = (String)msg.getHeader("containerName", String.class);
        String objectName = (String)msg.getHeader("objectName", String.class);
        ObjectHelper.notEmpty((String)containerName, (String)"Container name");
        ObjectHelper.notEmpty((String)objectName, (String)"Object name");
        SwiftObject out = this.os.objectStorage().objects().get(containerName, objectName);
        msg.setBody((Object)out);
    }

    private void doGetAll(Exchange exchange) {
        Message msg = exchange.getIn();
        String name = (String)msg.getHeader("containerName", msg.getHeader("name", String.class), String.class);
        ObjectHelper.notEmpty((String)name, (String)"Container name");
        List out = this.os.objectStorage().objects().list(name);
        exchange.getIn().setBody((Object)out);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String containerName = (String)msg.getHeader("containerName", String.class);
        String objectName = (String)msg.getHeader("objectName", String.class);
        ObjectHelper.notEmpty((String)containerName, (String)"Container name");
        ObjectHelper.notEmpty((String)objectName, (String)"Object name");
        ActionResponse out = this.os.objectStorage().objects().delete(containerName, objectName);
        msg.setBody((Object)out.getFault());
        msg.setFault(!out.isSuccess());
    }

    private void doGetMetadata(Exchange exchange) {
        Message msg = exchange.getIn();
        String containerName = (String)msg.getHeader("containerName", String.class);
        String objectName = (String)msg.getHeader("objectName", String.class);
        ObjectHelper.notEmpty((String)containerName, (String)"Container name");
        ObjectHelper.notEmpty((String)objectName, (String)"Object name");
        msg.setBody((Object)this.os.objectStorage().objects().getMetadata(containerName, objectName));
    }

    private void doUpdateMetadata(Exchange exchange) {
        Message msg = exchange.getIn();
        String containerName = (String)msg.getHeader("containerName", String.class);
        String objectName = (String)msg.getHeader("objectName", String.class);
        ObjectHelper.notEmpty((String)containerName, (String)"Container name");
        ObjectHelper.notEmpty((String)objectName, (String)"Object name");
        boolean success = this.os.objectStorage().objects().updateMetadata(ObjectLocation.create((String)containerName, (String)objectName), (Map)msg.getBody(Map.class));
        msg.setFault(!success);
        if (!success) {
            msg.setBody((Object)"Updating metadata was not successful");
        }
    }
}

