/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cm.client;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.camel.component.cm.validation.constraints.E164;

public class SMSMessage {
    @E164
    private final String phoneNumber;
    @NotNull
    private final String message;
    @Size(min=1, max=11)
    @Pattern(regexp="^[A-Za-z0-9]+$")
    private final String from;
    @Size(min=1, max=32)
    @Pattern(regexp="^[A-Za-z0-9]+$")
    private final String id;

    public SMSMessage(String message, String phoneNumber) {
        this(null, message, phoneNumber, null);
    }

    public SMSMessage(String id, String message, String phoneNumber) {
        this(id, message, phoneNumber, null);
    }

    public SMSMessage(String id, String message, String phoneNumber, String from) {
        this.id = id;
        this.message = message;
        this.phoneNumber = phoneNumber;
        this.from = from;
    }

    public String getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getFrom() {
        return this.from;
    }

    public String toString() {
        StringBuffer toS = new StringBuffer("{phoneNumber: " + this.phoneNumber + ", message: " + this.message);
        if (this.from != null && !this.from.isEmpty()) {
            toS.append(", from: " + this.from);
        }
        if (this.id != null && !this.id.isEmpty()) {
            toS.append(", id: " + this.id);
        }
        toS.append(" }");
        return toS.toString();
    }
}

