/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.s3;

import com.amazonaws.HttpMethod;
import com.amazonaws.services.cloudfront.model.InvalidArgumentException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.DeleteBucketRequest;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.UploadPartRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.aws.common.AwsExchangeUtil;
import org.apache.camel.component.aws.s3.S3Configuration;
import org.apache.camel.component.aws.s3.S3Endpoint;
import org.apache.camel.component.aws.s3.S3Operations;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(S3Producer.class);
    private transient String s3ProducerToString;

    public S3Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        S3Operations operation = this.determineOperation(exchange);
        if (ObjectHelper.isEmpty((Object)((Object)operation))) {
            if (this.getConfiguration().isMultiPartUpload()) {
                this.processMultiPart(exchange);
            } else {
                this.processSingleOp(exchange);
            }
        } else {
            switch (operation) {
                case copyObject: {
                    this.copyObject(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case deleteObject: {
                    this.deleteObject(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case listBuckets: {
                    this.listBuckets(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case deleteBucket: {
                    this.deleteBucket(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case downloadLink: {
                    this.createDownloadLink(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported operation");
                }
            }
        }
    }

    public void processMultiPart(Exchange exchange) throws Exception {
        AccessControlList acl;
        String cannedAcl;
        File filePayload = null;
        Object obj = exchange.getIn().getMandatoryBody();
        if (obj instanceof WrappedFile) {
            obj = ((WrappedFile)obj).getFile();
        }
        if (!(obj instanceof File)) {
            throw new InvalidArgumentException("aws-s3: MultiPart upload requires a File input.");
        }
        filePayload = (File)obj;
        ObjectMetadata objectMetadata = this.determineMetadata(exchange);
        if (objectMetadata.getContentLength() == 0L) {
            objectMetadata.setContentLength(filePayload.length());
        }
        String keyName = this.determineKey(exchange);
        InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(this.getConfiguration().getBucketName(), keyName, objectMetadata);
        String storageClass = this.determineStorageClass(exchange);
        if (storageClass != null) {
            initRequest.setStorageClass(StorageClass.fromValue((String)storageClass));
        }
        if ((cannedAcl = (String)exchange.getIn().getHeader("CamelAwsS3CannedAcl", String.class)) != null) {
            CannedAccessControlList objectAcl = CannedAccessControlList.valueOf((String)cannedAcl);
            initRequest.setCannedACL(objectAcl);
        }
        if ((acl = (AccessControlList)exchange.getIn().getHeader("CamelAwsS3Acl", AccessControlList.class)) != null) {
            initRequest.setAccessControlList(acl);
        }
        if (this.getConfiguration().isUseAwsKMS()) {
            SSEAwsKeyManagementParams keyManagementParams = ObjectHelper.isNotEmpty((Object)this.getConfiguration().getAwsKMSKeyId()) ? new SSEAwsKeyManagementParams(this.getConfiguration().getAwsKMSKeyId()) : new SSEAwsKeyManagementParams();
            initRequest.setSSEAwsKeyManagementParams(keyManagementParams);
        }
        LOG.trace("Initiating multipart upload [{}] from exchange [{}]...", (Object)initRequest, (Object)exchange);
        InitiateMultipartUploadResult initResponse = this.getEndpoint().getS3Client().initiateMultipartUpload(initRequest);
        long contentLength = objectMetadata.getContentLength();
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        long partSize = this.getConfiguration().getPartSize();
        CompleteMultipartUploadResult uploadResult = null;
        long filePosition = 0L;
        try {
            int part = 1;
            while (filePosition < contentLength) {
                partSize = Math.min(partSize, contentLength - filePosition);
                UploadPartRequest uploadRequest = new UploadPartRequest().withBucketName(this.getConfiguration().getBucketName()).withKey(keyName).withUploadId(initResponse.getUploadId()).withPartNumber(part).withFileOffset(filePosition).withFile(filePayload).withPartSize(partSize);
                LOG.trace("Uploading part [{}] for {}", (Object)part, (Object)keyName);
                partETags.add(this.getEndpoint().getS3Client().uploadPart(uploadRequest).getPartETag());
                filePosition += partSize;
                ++part;
            }
            CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest(this.getConfiguration().getBucketName(), keyName, initResponse.getUploadId(), partETags);
            uploadResult = this.getEndpoint().getS3Client().completeMultipartUpload(compRequest);
        }
        catch (Exception e) {
            this.getEndpoint().getS3Client().abortMultipartUpload(new AbortMultipartUploadRequest(this.getConfiguration().getBucketName(), keyName, initResponse.getUploadId()));
            throw e;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setHeader("CamelAwsS3ETag", (Object)uploadResult.getETag());
        if (uploadResult.getVersionId() != null) {
            message.setHeader("CamelAwsS3VersionId", (Object)uploadResult.getVersionId());
        }
        if (this.getConfiguration().isDeleteAfterWrite() && filePayload != null) {
            FileUtil.deleteFile((File)filePayload);
        }
    }

    public void processSingleOp(Exchange exchange) throws Exception {
        AccessControlList acl;
        String cannedAcl;
        ObjectMetadata objectMetadata = this.determineMetadata(exchange);
        File filePayload = null;
        InputStream is = null;
        ByteArrayOutputStream baos = null;
        Object obj = exchange.getIn().getMandatoryBody();
        PutObjectRequest putObjectRequest = null;
        if (obj instanceof WrappedFile) {
            obj = ((WrappedFile)obj).getFile();
        }
        if (obj instanceof File) {
            filePayload = (File)obj;
            is = new FileInputStream(filePayload);
        } else {
            is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
            baos = this.determineLengthInputStream(is);
            objectMetadata.setContentLength((long)baos.size());
            is = new ByteArrayInputStream(baos.toByteArray());
        }
        putObjectRequest = new PutObjectRequest(this.getConfiguration().getBucketName(), this.determineKey(exchange), is, objectMetadata);
        String storageClass = this.determineStorageClass(exchange);
        if (storageClass != null) {
            putObjectRequest.setStorageClass(storageClass);
        }
        if ((cannedAcl = (String)exchange.getIn().getHeader("CamelAwsS3CannedAcl", String.class)) != null) {
            CannedAccessControlList objectAcl = CannedAccessControlList.valueOf((String)cannedAcl);
            putObjectRequest.setCannedAcl(objectAcl);
        }
        if ((acl = (AccessControlList)exchange.getIn().getHeader("CamelAwsS3Acl", AccessControlList.class)) != null) {
            putObjectRequest.setAccessControlList(acl);
        }
        if (this.getConfiguration().isUseAwsKMS()) {
            SSEAwsKeyManagementParams keyManagementParams = ObjectHelper.isNotEmpty((Object)this.getConfiguration().getAwsKMSKeyId()) ? new SSEAwsKeyManagementParams(this.getConfiguration().getAwsKMSKeyId()) : new SSEAwsKeyManagementParams();
            putObjectRequest.setSSEAwsKeyManagementParams(keyManagementParams);
        }
        LOG.trace("Put object [{}] from exchange [{}]...", (Object)putObjectRequest, (Object)exchange);
        PutObjectResult putObjectResult = this.getEndpoint().getS3Client().putObject(putObjectRequest);
        LOG.trace("Received result [{}]", (Object)putObjectResult);
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setHeader("CamelAwsS3ETag", (Object)putObjectResult.getETag());
        if (putObjectResult.getVersionId() != null) {
            message.setHeader("CamelAwsS3VersionId", (Object)putObjectResult.getVersionId());
        }
        IOHelper.close((Closeable)putObjectRequest.getInputStream());
        IOHelper.close((Closeable)is);
        if (this.getConfiguration().isDeleteAfterWrite() && filePayload != null) {
            FileUtil.deleteFile((File)filePayload);
        }
    }

    private void copyObject(AmazonS3 s3Client, Exchange exchange) {
        String bucketName = (String)exchange.getIn().getHeader("CamelAwsS3BucketName", String.class);
        if (ObjectHelper.isEmpty((Object)bucketName)) {
            bucketName = this.getConfiguration().getBucketName();
        }
        String sourceKey = (String)exchange.getIn().getHeader("CamelAwsS3Key", String.class);
        String destinationKey = (String)exchange.getIn().getHeader("CamelAwsS3DestinationKey", String.class);
        String bucketNameDestination = (String)exchange.getIn().getHeader("CamelAwsS3BucketDestinationName", String.class);
        String versionId = (String)exchange.getIn().getHeader("CamelAwsS3VersionId", String.class);
        if (ObjectHelper.isEmpty((Object)bucketName)) {
            throw new IllegalArgumentException("Bucket Name must be specified for copyObject Operation");
        }
        if (ObjectHelper.isEmpty((Object)bucketNameDestination)) {
            throw new IllegalArgumentException("Bucket Name Destination must be specified for copyObject Operation");
        }
        if (ObjectHelper.isEmpty((Object)sourceKey)) {
            throw new IllegalArgumentException("Source Key must be specified for copyObject Operation");
        }
        if (ObjectHelper.isEmpty((Object)destinationKey)) {
            throw new IllegalArgumentException("Destination Key must be specified for copyObject Operation");
        }
        CopyObjectRequest copyObjectRequest = ObjectHelper.isEmpty((Object)versionId) ? new CopyObjectRequest(bucketName, sourceKey, bucketNameDestination, destinationKey) : new CopyObjectRequest(bucketName, sourceKey, versionId, bucketNameDestination, destinationKey);
        if (this.getConfiguration().isUseAwsKMS()) {
            SSEAwsKeyManagementParams keyManagementParams = ObjectHelper.isNotEmpty((Object)this.getConfiguration().getAwsKMSKeyId()) ? new SSEAwsKeyManagementParams(this.getConfiguration().getAwsKMSKeyId()) : new SSEAwsKeyManagementParams();
            copyObjectRequest.setSSEAwsKeyManagementParams(keyManagementParams);
        }
        CopyObjectResult copyObjectResult = s3Client.copyObject(copyObjectRequest);
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setHeader("CamelAwsS3ETag", (Object)copyObjectResult.getETag());
        if (copyObjectResult.getVersionId() != null) {
            message.setHeader("CamelAwsS3VersionId", (Object)copyObjectResult.getVersionId());
        }
    }

    private void deleteObject(AmazonS3 s3Client, Exchange exchange) {
        String bucketName = (String)exchange.getIn().getHeader("CamelAwsS3BucketName", String.class);
        if (ObjectHelper.isEmpty((Object)bucketName)) {
            bucketName = this.getConfiguration().getBucketName();
        }
        String sourceKey = (String)exchange.getIn().getHeader("CamelAwsS3Key", String.class);
        if (ObjectHelper.isEmpty((Object)bucketName)) {
            throw new IllegalArgumentException("Bucket Name must be specified for deleteObject Operation");
        }
        if (ObjectHelper.isEmpty((Object)sourceKey)) {
            throw new IllegalArgumentException("Source Key must be specified for deleteObject Operation");
        }
        DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(bucketName, sourceKey);
        s3Client.deleteObject(deleteObjectRequest);
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)true);
    }

    private void listBuckets(AmazonS3 s3Client, Exchange exchange) {
        List bucketsList = s3Client.listBuckets();
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)bucketsList);
    }

    private void deleteBucket(AmazonS3 s3Client, Exchange exchange) {
        String bucketName = (String)exchange.getIn().getHeader("CamelAwsS3BucketName", String.class);
        if (ObjectHelper.isEmpty((Object)bucketName)) {
            bucketName = this.getConfiguration().getBucketName();
        }
        DeleteBucketRequest deleteBucketRequest = new DeleteBucketRequest(bucketName);
        s3Client.deleteBucket(deleteBucketRequest);
    }

    private S3Operations determineOperation(Exchange exchange) {
        S3Operations operation = (S3Operations)((Object)exchange.getIn().getHeader("CamelAwsS3Operation", S3Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    private ObjectMetadata determineMetadata(Exchange exchange) {
        String encryption;
        Map s3Headers;
        Map userMetadata;
        Date lastModified;
        String contentMD5;
        String contentEncoding;
        String contentDisposition;
        String cacheControl;
        String contentType;
        ObjectMetadata objectMetadata = new ObjectMetadata();
        Long contentLength = (Long)exchange.getIn().getHeader("CamelAwsS3ContentLength", Long.class);
        if (contentLength != null) {
            objectMetadata.setContentLength(contentLength.longValue());
        }
        if ((contentType = (String)exchange.getIn().getHeader("CamelAwsS3ContentType", String.class)) != null) {
            objectMetadata.setContentType(contentType);
        }
        if ((cacheControl = (String)exchange.getIn().getHeader("CamelAwsS3ContentControl", String.class)) != null) {
            objectMetadata.setCacheControl(cacheControl);
        }
        if ((contentDisposition = (String)exchange.getIn().getHeader("CamelAwsS3ContentDisposition", String.class)) != null) {
            objectMetadata.setContentDisposition(contentDisposition);
        }
        if ((contentEncoding = (String)exchange.getIn().getHeader("CamelAwsS3ContentEncoding", String.class)) != null) {
            objectMetadata.setContentEncoding(contentEncoding);
        }
        if ((contentMD5 = (String)exchange.getIn().getHeader("CamelAwsS3ContentMD5", String.class)) != null) {
            objectMetadata.setContentMD5(contentMD5);
        }
        if ((lastModified = (Date)exchange.getIn().getHeader("CamelAwsS3LastModified", Date.class)) != null) {
            objectMetadata.setLastModified(lastModified);
        }
        if ((userMetadata = CastUtils.cast((Map)((Map)exchange.getIn().getHeader("CamelAwsS3UserMetadata", Map.class)))) != null) {
            objectMetadata.setUserMetadata(userMetadata);
        }
        if ((s3Headers = CastUtils.cast((Map)((Map)exchange.getIn().getHeader("CamelAwsS3Headers", Map.class)))) != null) {
            for (Map.Entry entry : s3Headers.entrySet()) {
                objectMetadata.setHeader((String)entry.getKey(), entry.getValue());
            }
        }
        if ((encryption = (String)exchange.getIn().getHeader("CamelAwsS3ServerSideEncryption", (Object)this.getConfiguration().getServerSideEncryption(), String.class)) != null) {
            objectMetadata.setSSEAlgorithm(encryption);
        }
        return objectMetadata;
    }

    private String determineKey(Exchange exchange) {
        String key = (String)exchange.getIn().getHeader("CamelAwsS3Key", String.class);
        if (key == null) {
            throw new IllegalArgumentException("AWS S3 Key header missing.");
        }
        return key;
    }

    private String determineStorageClass(Exchange exchange) {
        String storageClass = (String)exchange.getIn().getHeader("CamelAwsS3StorageClass", String.class);
        if (storageClass == null) {
            storageClass = this.getConfiguration().getStorageClass();
        }
        return storageClass;
    }

    private ByteArrayOutputStream determineLengthInputStream(InputStream is) throws IOException {
        int count;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        while ((count = is.read(bytes)) > 0) {
            out.write(bytes, 0, count);
        }
        return out;
    }

    private void createDownloadLink(AmazonS3 s3Client, Exchange exchange) {
        String bucketName = (String)exchange.getIn().getHeader("CamelAwsS3BucketName", String.class);
        if (ObjectHelper.isEmpty((Object)bucketName)) {
            bucketName = this.getConfiguration().getBucketName();
        }
        if (bucketName == null) {
            throw new IllegalArgumentException("AWS S3 Bucket name header is missing.");
        }
        String key = (String)exchange.getIn().getHeader("CamelAwsS3Key", String.class);
        if (key == null) {
            throw new IllegalArgumentException("AWS S3 Key header is missing.");
        }
        Date expiration = new Date();
        long milliSeconds = expiration.getTime();
        Long expirationMillis = (Long)exchange.getIn().getHeader("CamelAwsS3DownloadLinkExpiration", Long.class);
        milliSeconds = expirationMillis != null ? (milliSeconds += expirationMillis.longValue()) : (milliSeconds += 3600000L);
        expiration.setTime(milliSeconds);
        GeneratePresignedUrlRequest generatePresignedUrlRequest = new GeneratePresignedUrlRequest(bucketName, key);
        generatePresignedUrlRequest.setMethod(HttpMethod.GET);
        generatePresignedUrlRequest.setExpiration(expiration);
        URL url = s3Client.generatePresignedUrl(generatePresignedUrlRequest);
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setHeader("CamelAwsS3DownloadLink", (Object)url.toString());
    }

    protected S3Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.s3ProducerToString == null) {
            this.s3ProducerToString = "S3Producer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.s3ProducerToString;
    }

    public S3Endpoint getEndpoint() {
        return (S3Endpoint)super.getEndpoint();
    }
}

