/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.cloud;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.component.zookeeper.ZooKeeperCuratorConfiguration;
import org.apache.camel.component.zookeeper.ZooKeeperCuratorHelper;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;
import org.apache.camel.impl.cloud.DefaultServiceDiscovery;
import org.apache.camel.util.ObjectHelper;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.codehaus.jackson.map.annotate.JsonRootName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperServiceDiscovery
extends DefaultServiceDiscovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperServiceDiscovery.class);
    private final ZooKeeperCuratorConfiguration configuration;
    private final boolean managedInstance;
    private CuratorFramework curator;
    private ServiceDiscovery<MetaData> serviceDiscovery;

    public ZooKeeperServiceDiscovery(ZooKeeperCuratorConfiguration configuration) {
        this.configuration = configuration;
        this.curator = configuration.getCuratorFramework();
        this.managedInstance = Objects.isNull(this.curator);
    }

    protected void doStart() throws Exception {
        if (this.curator == null) {
            ObjectHelper.notNull((Object)this.getCamelContext(), (String)"Camel Context");
            ObjectHelper.notNull((Object)this.configuration.getBasePath(), (String)"ZooKeeper base path");
            LOGGER.debug("Starting ZooKeeper Curator with namespace '{}',  nodes: '{}'", (Object)this.configuration.getNamespace(), (Object)String.join((CharSequence)",", this.configuration.getNodes()));
            this.curator = ZooKeeperCuratorHelper.createCurator(this.configuration);
            this.curator.start();
        }
        if (this.serviceDiscovery == null) {
            ObjectHelper.notNull((Object)this.configuration.getBasePath(), (String)"ZooKeeper base path");
            LOGGER.debug("Starting ZooKeeper ServiceDiscoveryBuilder with base path '{}'", (Object)this.configuration.getBasePath());
            this.serviceDiscovery = ZooKeeperCuratorHelper.createServiceDiscovery(this.configuration, this.curator, MetaData.class);
            this.serviceDiscovery.start();
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.serviceDiscovery != null) {
            try {
                this.serviceDiscovery.close();
            }
            catch (Exception e) {
                LOGGER.warn("Error closing Curator ServiceDiscovery", (Throwable)e);
            }
        }
        if (this.curator != null && this.managedInstance) {
            this.curator.close();
        }
    }

    public List<ServiceDefinition> getServices(String name) {
        if (this.serviceDiscovery == null) {
            return Collections.emptyList();
        }
        try {
            return this.serviceDiscovery.queryForInstances(name).stream().map(si -> {
                HashMap<String, String> meta = new HashMap<String, String>();
                ObjectHelper.ifNotEmpty((Object)si.getPayload(), meta::putAll);
                meta.put("service_name", si.getName());
                meta.put("service_id", si.getId());
                meta.put("service_type", si.getServiceType().name());
                return new DefaultServiceDefinition(si.getName(), si.getAddress(), (si.getSslPort() != null ? si.getSslPort() : si.getPort()).intValue(), meta);
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    @JsonRootName(value="meta")
    public static final class MetaData
    extends HashMap<String, String> {
    }
}

