/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.parser.helper;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.parser.helper.XmlLineNumberParser;
import org.jboss.forge.roaster.model.util.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CamelXmlHelper {
    private CamelXmlHelper() {
    }

    public static String getSafeAttribute(Node node, String key) {
        Node attr;
        if (node != null && (attr = node.getAttributes().getNamedItem(key)) != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    public static List<Node> findAllEndpoints(Document dom) {
        Node child;
        int i;
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList list = dom.getElementsByTagName("endpoint");
        for (i = 0; i < list.getLength(); ++i) {
            Node node;
            NamedNodeMap attrs;
            child = list.item(i);
            if (!"endpoint".equals(child.getNodeName())) continue;
            String ns = child.getNamespaceURI();
            if (ns == null && (attrs = child.getAttributes()) != null && (node = attrs.getNamedItem("xmlns")) != null) {
                ns = node.getNodeValue();
            }
            if (ns != null && !ns.contains("camel")) continue;
            nodes.add(child);
        }
        list = dom.getElementsByTagName("onException");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = dom.getElementsByTagName("onCompletion");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = dom.getElementsByTagName("intercept");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = dom.getElementsByTagName("interceptFrom");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = dom.getElementsByTagName("interceptSendToEndpoint");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = dom.getElementsByTagName("rest");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            if (!"route".equals(child.getNodeName()) && !"to".equals(child.getNodeName())) continue;
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = dom.getElementsByTagName("route");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            if (!"route".equals(child.getNodeName())) continue;
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        return nodes;
    }

    private static void findAllUrisRecursive(Node node, List<Node> nodes) {
        NodeList children;
        String url = CamelXmlHelper.getSafeAttribute(node, "uri");
        if (url != null) {
            nodes.add(node);
        }
        if ((children = node.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                CamelXmlHelper.findAllUrisRecursive(child, nodes);
            }
        }
    }

    public static List<Node> findAllRoutes(Document dom) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList list = dom.getElementsByTagName("route");
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (!"route".equals(child.getNodeName())) continue;
            nodes.add(child);
        }
        return nodes;
    }

    public static List<Node> findAllSimpleExpressions(Document dom) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList list = dom.getElementsByTagName("route");
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (!"route".equals(child.getNodeName())) continue;
            CamelXmlHelper.findAllSimpleExpressionsRecursive(child, nodes);
        }
        return nodes;
    }

    private static void findAllSimpleExpressionsRecursive(Node node, List<Node> nodes) {
        NodeList children;
        if ("simple".equals(node.getNodeName())) {
            nodes.add(node);
        }
        if ((children = node.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                CamelXmlHelper.findAllSimpleExpressionsRecursive(child, nodes);
            }
        }
    }

    public static Element getSelectedCamelElementNode(String key, InputStream resourceInputStream) throws Exception {
        Node selectedNode;
        Document root = CamelXmlHelper.loadCamelXmlFileAsDom(resourceInputStream);
        Element selectedElement = null;
        if (root != null && (selectedNode = CamelXmlHelper.findCamelNodeInDocument(root, key)) instanceof Element) {
            selectedElement = (Element)selectedNode;
        }
        return selectedElement;
    }

    private static Document loadCamelXmlFileAsDom(InputStream resourceInputStream) throws Exception {
        Document root = XmlLineNumberParser.parseXml(resourceInputStream, "camelContext,routes,rests", "http://camel.apache.org/schema/spring");
        return root;
    }

    private static Node findCamelNodeInDocument(Document root, String key) {
        Node selectedNode = null;
        if (root != null && !Strings.isBlank((String)key)) {
            String[] paths = key.split("/");
            NodeList camels = CamelXmlHelper.getCamelContextElements(root);
            if (camels != null) {
                HashMap<String, Integer> rootNodeCounts = new HashMap<String, Integer>();
                int size = camels.getLength();
                for (int i = 0; i < size; ++i) {
                    Node node = camels.item(i);
                    boolean first = true;
                    for (String path : paths) {
                        if (first) {
                            first = false;
                            String actual = CamelXmlHelper.getIdOrIndex(node, rootNodeCounts);
                            if (!CamelXmlHelper.equal(actual, path)) {
                                node = null;
                            }
                        } else {
                            node = CamelXmlHelper.findCamelNodeForPath(node, path);
                        }
                        if (node == null) break;
                    }
                    if (node == null) continue;
                    return node;
                }
            }
        }
        return selectedNode;
    }

    private static Node findCamelNodeForPath(Node node, String path) {
        NodeList childNodes = node.getChildNodes();
        if (childNodes != null) {
            HashMap<String, Integer> nodeCounts = new HashMap<String, Integer>();
            int size = childNodes.getLength();
            for (int i = 0; i < size; ++i) {
                String actual;
                Node child = childNodes.item(i);
                if (!(child instanceof Element) || !CamelXmlHelper.equal(actual = CamelXmlHelper.getIdOrIndex(child, nodeCounts), path)) continue;
                return child;
            }
        }
        return null;
    }

    private static String getIdOrIndex(Node node, Map<String, Integer> nodeCounts) {
        String answer = null;
        if (node instanceof Element) {
            Integer countObject;
            Element element = (Element)node;
            String elementName = element.getTagName();
            if ("routes".equals(elementName)) {
                elementName = "camelContext";
            }
            int count = (countObject = nodeCounts.get(elementName)) != null ? countObject : 0;
            nodeCounts.put(elementName, ++count);
            answer = element.getAttribute("id");
            if (Strings.isBlank((String)answer)) {
                answer = "_" + elementName + count;
            }
        }
        return answer;
    }

    private static NodeList getCamelContextElements(Document dom) {
        NodeList camels = dom.getElementsByTagName("camelContext");
        if (camels == null || camels.getLength() == 0) {
            camels = dom.getElementsByTagName("routes");
        }
        return camels;
    }

    private static boolean equal(Object a, Object b) {
        return a == b ? true : a != null && b != null && a.equals(b);
    }
}

