/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client;

import java.util.Objects;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.milo.Messages;
import org.apache.camel.component.milo.client.MiloClientConnection;
import org.apache.camel.component.milo.client.MiloClientEndpoint;
import org.apache.camel.component.milo.client.MiloClientItemConfiguration;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiloClientConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(MiloClientConsumer.class);
    private final MiloClientConnection connection;
    private final MiloClientItemConfiguration configuration;
    private MiloClientConnection.MonitorHandle handle;

    public MiloClientConsumer(MiloClientEndpoint endpoint, Processor processor, MiloClientConnection connection, MiloClientItemConfiguration configuration) {
        super((Endpoint)endpoint, processor);
        Objects.requireNonNull(connection);
        Objects.requireNonNull(configuration);
        this.connection = connection;
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.handle = this.connection.monitorValue(this.configuration, this::handleValueUpdate);
    }

    protected void doStop() throws Exception {
        if (this.handle != null) {
            this.handle.unregister();
            this.handle = null;
        }
        super.doStop();
    }

    private void handleValueUpdate(DataValue value) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.setIn(this.mapMessage(value));
        try {
            this.getAsyncProcessor().process(exchange);
        }
        catch (Exception e) {
            LOG.debug("Failed to process message", (Throwable)e);
        }
    }

    private Message mapMessage(DataValue value) {
        if (value == null) {
            return null;
        }
        DefaultMessage result = new DefaultMessage(this.getEndpoint().getCamelContext());
        Messages.fillFromDataValue(value, result);
        return result;
    }
}

