/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.cloud.netflix;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.cloud.ServiceFilter;
import org.apache.camel.component.ribbon.cloud.RibbonServiceDefinition;

public class CamelCloudNetflixServerList
extends AbstractServerList<RibbonServiceDefinition> {
    private ServiceDiscovery serviceDiscovery;
    private ServiceFilter serviceFilter;
    private String serviceId;

    public CamelCloudNetflixServerList() {
        this(null, list -> list);
    }

    public CamelCloudNetflixServerList(ServiceDiscovery serviceDiscovery, ServiceFilter serviceFilter) {
        this.serviceDiscovery = serviceDiscovery;
        this.serviceFilter = serviceFilter;
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public void setServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    public ServiceFilter getServiceFilter() {
        return this.serviceFilter;
    }

    public void setServiceFilter(ServiceFilter serviceFilter) {
        this.serviceFilter = serviceFilter;
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.serviceId = clientConfig.getClientName();
    }

    public List<RibbonServiceDefinition> getInitialListOfServers() {
        if (this.serviceId == null) {
            return Collections.emptyList();
        }
        List services = this.serviceDiscovery.getServices(this.serviceId);
        if (this.serviceFilter != null) {
            services = this.serviceFilter.apply(services);
        }
        return this.convert(services);
    }

    public List<RibbonServiceDefinition> getUpdatedListOfServers() {
        if (this.serviceId == null) {
            return Collections.emptyList();
        }
        List services = this.serviceDiscovery.getServices(this.serviceId);
        if (this.serviceFilter != null) {
            services = this.serviceFilter.apply(services);
        }
        return this.convert(services);
    }

    private List<RibbonServiceDefinition> convert(List<? extends ServiceDefinition> definitions) {
        if (definitions.isEmpty()) {
            return Collections.emptyList();
        }
        return definitions.stream().map(RibbonServiceDefinition::new).collect(Collectors.toList());
    }
}

