/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.health;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.health.HealthCheckFilter;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.actuate.health.CamelHealthCheckIndicator;
import org.apache.camel.spring.boot.actuate.health.CamelHealthCheckIndicatorConfiguration;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={CamelContext.class, HealthIndicator.class})
@Conditional(value={Condition.class})
@ConditionalOnBean(value={CamelAutoConfiguration.class, CamelContext.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={CamelHealthCheckIndicatorConfiguration.class})
public class CamelHealthCheckIndicatorAutoConfiguration {
    @Autowired
    private CamelContext camelContext;
    @Autowired
    private CamelHealthCheckIndicatorConfiguration configuration;
    @Autowired(required=false)
    private List<HealthCheckFilter> filterList = Collections.emptyList();

    @Bean(name={"camel-health-checks"})
    @ConditionalOnMissingBean(value={CamelHealthCheckIndicator.class})
    public HealthIndicator camelHealthChecksIndicator() {
        Pattern pattern;
        ArrayList<HealthCheckFilter> filters = new ArrayList<HealthCheckFilter>(this.filterList);
        for (String exclusion : this.configuration.getExclusion().getIds()) {
            pattern = Pattern.compile(exclusion);
            filters.add(check -> exclusion.equals(check.getId()) || pattern.matcher(check.getId()).matches());
        }
        for (String exclusion : this.configuration.getExclusion().getGroups()) {
            pattern = Pattern.compile(exclusion);
            filters.add(check -> exclusion.equals(check.getGroup()) || pattern.matcher(check.getGroup()).matches());
        }
        return new CamelHealthCheckIndicator(this.camelContext, filters);
    }

    public static class Condition
    extends GroupCondition {
        public Condition() {
            super("camel.health", "camel.health.check.indicator");
        }
    }
}

