/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.language.spel;

import org.apache.camel.CamelContext;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.LanguageTestSupport;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.language.spel.bean.Dummy;

/**
 * Test access to beans defined in non-Spring context from SpEL expressions/predicates.
 */
public class SpelNonSpringTest extends LanguageTestSupport {

    @Override
    protected CamelContext createCamelContext() throws Exception {
        SimpleRegistry registry = new SimpleRegistry();
        registry.put("myDummy", new Dummy());
        return new DefaultCamelContext(registry);
    }

    public void testSpelBeanExpressions() throws Exception {
        assertExpression("#{@myDummy.foo == 'xyz'}", true);
        assertExpression("#{@myDummy.bar == 789}", true);
        assertExpression("#{@myDummy.bar.toString()}", "789");
        try {
            assertExpression("#{@notFound}", null);
        } catch (ExpressionEvaluationException ex) {
            assertStringContains(ex.getMessage(), "Could not resolve bean reference against Registry");
        }
    }
    
    public void testSpelBeanPredicates() throws Exception {
        assertPredicate("@myDummy.foo == 'xyz'");
        assertPredicate("@myDummy.bar == 789");
        assertPredicate("@myDummy.bar instanceof T(Integer)");
    }

    @Override
    protected String getLanguageName() {
        return "spel";
    }
}
