/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache.springboot;

import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.camel.component.cache.CacheConfiguration;
import org.apache.camel.component.cache.CacheEventListenerRegistry;
import org.apache.camel.component.cache.CacheLoaderRegistry;
import org.apache.camel.component.cache.CacheManagerFactory;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="camel.component.cache")
public class CacheComponentConfiguration
extends ComponentConfigurationPropertiesCommon {
    private CacheManagerFactory cacheManagerFactory;
    private CacheConfigurationNestedConfiguration configuration;
    private String configurationFile = "classpath:ehcache.xml";
    private Boolean resolvePropertyPlaceholders = true;

    public CacheManagerFactory getCacheManagerFactory() {
        return this.cacheManagerFactory;
    }

    public void setCacheManagerFactory(CacheManagerFactory cacheManagerFactory) {
        this.cacheManagerFactory = cacheManagerFactory;
    }

    public CacheConfigurationNestedConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CacheConfigurationNestedConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public void setConfigurationFile(String configurationFile) {
        this.configurationFile = configurationFile;
    }

    public Boolean getResolvePropertyPlaceholders() {
        return this.resolvePropertyPlaceholders;
    }

    public void setResolvePropertyPlaceholders(Boolean resolvePropertyPlaceholders) {
        this.resolvePropertyPlaceholders = resolvePropertyPlaceholders;
    }

    public static class CacheConfigurationNestedConfiguration {
        public static final Class CAMEL_NESTED_CLASS = CacheConfiguration.class;
        private String cacheName;
        private Integer maxElementsInMemory = 1000;
        @NestedConfigurationProperty
        private MemoryStoreEvictionPolicy memoryStoreEvictionPolicy;
        private Boolean overflowToDisk = true;
        @Deprecated
        private String diskStorePath;
        private Boolean eternal = false;
        private Long timeToLiveSeconds = 300L;
        private Long timeToIdleSeconds = 300L;
        private Boolean diskPersistent = false;
        private Long diskExpiryThreadIntervalSeconds;
        @NestedConfigurationProperty
        private CacheEventListenerRegistry eventListenerRegistry;
        @NestedConfigurationProperty
        private CacheLoaderRegistry cacheLoaderRegistry;
        private Boolean objectCache = false;

        public String getCacheName() {
            return this.cacheName;
        }

        public void setCacheName(String cacheName) {
            this.cacheName = cacheName;
        }

        public Integer getMaxElementsInMemory() {
            return this.maxElementsInMemory;
        }

        public void setMaxElementsInMemory(Integer maxElementsInMemory) {
            this.maxElementsInMemory = maxElementsInMemory;
        }

        public MemoryStoreEvictionPolicy getMemoryStoreEvictionPolicy() {
            return this.memoryStoreEvictionPolicy;
        }

        public void setMemoryStoreEvictionPolicy(MemoryStoreEvictionPolicy memoryStoreEvictionPolicy) {
            this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
        }

        public Boolean getOverflowToDisk() {
            return this.overflowToDisk;
        }

        public void setOverflowToDisk(Boolean overflowToDisk) {
            this.overflowToDisk = overflowToDisk;
        }

        @Deprecated
        @DeprecatedConfigurationProperty
        public String getDiskStorePath() {
            return this.diskStorePath;
        }

        @Deprecated
        public void setDiskStorePath(String diskStorePath) {
            this.diskStorePath = diskStorePath;
        }

        public Boolean getEternal() {
            return this.eternal;
        }

        public void setEternal(Boolean eternal) {
            this.eternal = eternal;
        }

        public Long getTimeToLiveSeconds() {
            return this.timeToLiveSeconds;
        }

        public void setTimeToLiveSeconds(Long timeToLiveSeconds) {
            this.timeToLiveSeconds = timeToLiveSeconds;
        }

        public Long getTimeToIdleSeconds() {
            return this.timeToIdleSeconds;
        }

        public void setTimeToIdleSeconds(Long timeToIdleSeconds) {
            this.timeToIdleSeconds = timeToIdleSeconds;
        }

        public Boolean getDiskPersistent() {
            return this.diskPersistent;
        }

        public void setDiskPersistent(Boolean diskPersistent) {
            this.diskPersistent = diskPersistent;
        }

        public Long getDiskExpiryThreadIntervalSeconds() {
            return this.diskExpiryThreadIntervalSeconds;
        }

        public void setDiskExpiryThreadIntervalSeconds(Long diskExpiryThreadIntervalSeconds) {
            this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds;
        }

        public CacheEventListenerRegistry getEventListenerRegistry() {
            return this.eventListenerRegistry;
        }

        public void setEventListenerRegistry(CacheEventListenerRegistry eventListenerRegistry) {
            this.eventListenerRegistry = eventListenerRegistry;
        }

        public CacheLoaderRegistry getCacheLoaderRegistry() {
            return this.cacheLoaderRegistry;
        }

        public void setCacheLoaderRegistry(CacheLoaderRegistry cacheLoaderRegistry) {
            this.cacheLoaderRegistry = cacheLoaderRegistry;
        }

        public Boolean getObjectCache() {
            return this.objectCache;
        }

        public void setObjectCache(Boolean objectCache) {
            this.objectCache = objectCache;
        }
    }
}

