/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.springboot.customizer;

import org.apache.camel.component.infinispan.InfinispanComponent;
import org.apache.camel.component.infinispan.springboot.InfinispanComponentAutoConfiguration;
import org.apache.camel.component.infinispan.springboot.customizer.EmbeddedCacheManagerCustomizerConfiguration;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spi.HasId;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.infinispan.commons.api.BasicCacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.Order;

@Order(value=101)
@Configuration
@Conditional(value={Conditions.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@AutoConfigureBefore(value={InfinispanComponentAutoConfiguration.class})
@EnableConfigurationProperties(value={EmbeddedCacheManagerCustomizerConfiguration.class})
public class EmbeddedCacheManagerCustomizer
implements HasId,
ComponentCustomizer<InfinispanComponent> {
    @Autowired
    private EmbeddedCacheManager cacheManager;
    @Autowired
    private EmbeddedCacheManagerCustomizerConfiguration configuration;

    public void customize(InfinispanComponent component) {
        if (this.configuration.isOverride() || component.getCacheContainer() == null) {
            component.setCacheContainer((BasicCacheContainer)this.cacheManager);
        }
    }

    public String getId() {
        return "camel.component.infinispan.customizer.embedded-cache-manager";
    }

    static class Conditions
    extends AllNestedConditions {
        public Conditions() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={CamelAutoConfiguration.class})
        static class OnCamelAutoConfiguration {
            OnCamelAutoConfiguration() {
            }
        }

        @ConditionalOnBean(value={EmbeddedCacheManager.class})
        static class OnCacheManager {
            OnCacheManager() {
            }
        }
    }
}

