/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.chronicle.engine;

import java.util.Map;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.tree.QueueView;
import org.apache.camel.Endpoint;
import org.apache.camel.InvokeOnHeader;
import org.apache.camel.Message;
import org.apache.camel.component.chronicle.engine.ChronicleEngineEndpoint;
import org.apache.camel.component.chronicle.engine.ChronicleEngineHelper;
import org.apache.camel.impl.HeaderSelectorProducer;
import org.apache.camel.util.ObjectHelper;

public class ChronicleEngineProducer
extends HeaderSelectorProducer {
    private final String uri;
    private ChronicleEngineHelper.WeakRef<TopicPublisher<Object, Object>> topicPublisher;
    private ChronicleEngineHelper.WeakRef<Publisher<Object>> publisher;
    private ChronicleEngineHelper.WeakRef<MapView<Object, Object>> mapView;
    private ChronicleEngineHelper.WeakRef<QueueView<Object, Object>> queueView;
    private AssetTree client;

    public ChronicleEngineProducer(ChronicleEngineEndpoint endpoint) {
        super((Endpoint)endpoint, "ChronicleEngineAction", endpoint.getConfiguration().getAction());
        this.uri = endpoint.getUri();
        this.topicPublisher = ChronicleEngineHelper.WeakRef.create(() -> this.client.acquireTopicPublisher(this.uri, Object.class, Object.class));
        this.publisher = ChronicleEngineHelper.WeakRef.create(() -> this.client.acquirePublisher(this.uri, Object.class));
        this.mapView = ChronicleEngineHelper.WeakRef.create(() -> this.client.acquireMap(this.uri, Object.class, Object.class));
        this.queueView = ChronicleEngineHelper.WeakRef.create(() -> this.client.acquireQueue(this.uri, Object.class, Object.class, endpoint.getConfiguration().getClusterName()));
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.client != null) {
            throw new IllegalStateException("AssetTree already configured");
        }
        this.client = ((ChronicleEngineEndpoint)this.getEndpoint()).createRemoteAssetTree();
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        super.doStop();
    }

    @InvokeOnHeader(value="PUBLISH")
    public void onPublish(Message message) {
        Object key = message.getHeader("ChronicleEngineKey");
        Object val = ChronicleEngineHelper.mandatoryBody(message);
        if (key == null) {
            this.publisher.get().publish(val);
        } else {
            this.topicPublisher.get().publish(key, val);
        }
    }

    @InvokeOnHeader(value="PUBLISH_AND_INDEX")
    public void onPublishAndIndex(Message message) {
        message.setHeader("ChronicleEngineQueueIndex", (Object)this.queueView.get().publishAndIndex(ChronicleEngineHelper.mandatoryKey(message), ChronicleEngineHelper.mandatoryBody(message)));
    }

    @InvokeOnHeader(value="PUT")
    public void onPut(Message message) {
        message.setHeader("ChronicleEngineOldValue", this.mapView.get().put(ChronicleEngineHelper.mandatoryKey(message), ChronicleEngineHelper.mandatoryBody(message)));
    }

    @InvokeOnHeader(value="GET_AND_PUT")
    public void onGetAndPut(Message message) {
        message.setBody(this.mapView.get().getAndPut(ChronicleEngineHelper.mandatoryKey(message), ChronicleEngineHelper.mandatoryBody(message)));
    }

    @InvokeOnHeader(value="PUT_ALL")
    public void onPutAll(Message message) {
        this.mapView.get().putAll((Map)ObjectHelper.notNull((Object)message.getBody(Map.class), (String)"ChronicleEngineValue"));
    }

    @InvokeOnHeader(value="PUT_IF_ABSENT")
    public void onPutIfAbsent(Message message) {
        message.setHeader("ChronicleEngineResult", this.mapView.get().putIfAbsent(ChronicleEngineHelper.mandatoryKey(message), ChronicleEngineHelper.mandatoryBody(message)));
    }

    @InvokeOnHeader(value="GET")
    public void onGet(Message message) {
        Long index = (Long)message.getHeader("ChronicleEngineQueueIndex", Long.class);
        if (index == null) {
            message.setBody(this.mapView.get().getOrDefault(ChronicleEngineHelper.mandatoryKey(message), message.getHeader("ChronicleEngineDefaultValue")));
        } else {
            QueueView.Excerpt excerpt = this.queueView.get().getExcerpt(index.longValue());
            message.setHeader("ChronicleEnginePath", excerpt.topic());
            message.setBody(excerpt.message());
        }
    }

    @InvokeOnHeader(value="GET_AND_REMOVE")
    public void onGetAndRemove(Message message) {
        message.setBody(this.mapView.get().getAndRemove(ChronicleEngineHelper.mandatoryKey(message)));
    }

    @InvokeOnHeader(value="REMOVE")
    public void onRemove(Message message) {
        Object oldValue = message.getHeader("ChronicleEngineOldValue");
        if (oldValue != null) {
            message.setHeader("ChronicleEngineResult", (Object)this.mapView.get().remove(ChronicleEngineHelper.mandatoryKey(message), oldValue));
        } else {
            message.setHeader("ChronicleEngineOldValue", this.mapView.get().remove(ChronicleEngineHelper.mandatoryKey(message)));
        }
    }

    @InvokeOnHeader(value="IS_EMPTY")
    public void onIsEmpty(Message message) {
        message.setHeader("ChronicleEngineResult", (Object)this.mapView.get().isEmpty());
    }

    @InvokeOnHeader(value="SIZE")
    public void onSize(Message message) {
        message.setHeader("ChronicleEngineResult", (Object)this.mapView.get().size());
    }
}

