/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq.reply;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.rabbitmq.reply.ReplyHandler;
import org.apache.camel.component.rabbitmq.reply.ReplyManager;
import org.apache.camel.component.rabbitmq.reply.ReplyManagerSupport;
import org.apache.camel.component.rabbitmq.reply.TemporaryQueueReplyHandler;

public class TemporaryQueueReplyManager
extends ReplyManagerSupport {
    private RabbitConsumer consumer;

    public TemporaryQueueReplyManager(CamelContext camelContext) {
        super(camelContext);
    }

    @Override
    protected ReplyHandler createReplyHandler(ReplyManager replyManager, Exchange exchange, AsyncCallback callback, String originalCorrelationId, String correlationId, long requestTimeout) {
        return new TemporaryQueueReplyHandler(this, exchange, callback, originalCorrelationId, correlationId, requestTimeout);
    }

    @Override
    public void updateCorrelationId(String correlationId, String newCorrelationId, long requestTimeout) {
        this.log.trace("Updated provisional correlationId [{}] to expected correlationId [{}]", (Object)correlationId, (Object)newCorrelationId);
        ReplyHandler handler = this.correlation.remove(correlationId);
        if (handler != null) {
            this.correlation.put(newCorrelationId, handler, requestTimeout);
        }
    }

    @Override
    protected void handleReplyMessage(String correlationID, AMQP.BasicProperties properties, byte[] message) {
        ReplyHandler handler = this.correlation.get(correlationID);
        if (handler == null && this.endpoint.isUseMessageIDAsCorrelationID()) {
            handler = this.waitForProvisionCorrelationToBeUpdated(correlationID, message);
        }
        if (handler != null) {
            this.correlation.remove(correlationID);
            handler.onReply(correlationID, properties, message);
        } else {
            this.log.warn("Reply received for unknown correlationID [{}]. The message will be ignored: {}", (Object)correlationID, (Object)message);
        }
    }

    @Override
    protected Connection createListenerContainer() throws Exception {
        this.log.trace("Creating connection");
        Connection conn = this.endpoint.connect(this.executorService);
        this.log.trace("Creating channel");
        Channel channel = conn.createChannel();
        if (this.endpoint.isPrefetchEnabled()) {
            channel.basicQos(this.endpoint.getPrefetchSize(), this.endpoint.getPrefetchCount(), this.endpoint.isPrefetchGlobal());
        }
        AMQP.Queue.DeclareOk result = channel.queueDeclare();
        this.log.debug("Using temporary queue name: {}", (Object)result.getQueue());
        this.setReplyTo(result.getQueue());
        channel.queueBind(this.getReplyTo(), this.endpoint.getExchangeName(), this.getReplyTo());
        this.consumer = new RabbitConsumer(this, channel);
        this.consumer.start();
        return conn;
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.consumer.stop();
    }

    class RabbitConsumer
    extends DefaultConsumer {
        private final TemporaryQueueReplyManager consumer;
        private final Channel channel;
        private String tag;

        RabbitConsumer(TemporaryQueueReplyManager consumer, Channel channel) {
            super(channel);
            this.consumer = consumer;
            this.channel = channel;
        }

        public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
            this.consumer.onMessage(properties, body);
        }

        private void start() throws IOException {
            this.tag = this.channel.basicConsume(TemporaryQueueReplyManager.this.getReplyTo(), TemporaryQueueReplyManager.this.endpoint.isAutoAck(), (Consumer)this);
        }

        private void stop() throws IOException, TimeoutException {
            if (this.channel.isOpen()) {
                if (this.tag != null) {
                    this.channel.basicCancel(this.tag);
                }
                this.channel.close();
            }
        }
    }
}

