/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.converter;

import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class DelegatingXMLStreamReader
implements XMLStreamReader {
    private XMLStreamReader reader;
    private final String[] xprefixes;
    private int depth;

    DelegatingXMLStreamReader(XMLStreamReader reader, Map<String, String> nsmap) {
        this.reader = reader;
        Set<String> prefixes = nsmap.keySet();
        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
            prefixes.remove(reader.getNamespacePrefix(i));
        }
        this.xprefixes = prefixes.toArray(new String[0]);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.reader.getProperty(name);
    }

    @Override
    public int next() throws XMLStreamException {
        int c = this.reader.next();
        if (c == 1) {
            ++this.depth;
        } else if (c == 2) {
            --this.depth;
        }
        return c;
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        this.reader.require(type, namespaceURI, localName);
    }

    @Override
    public String getElementText() throws XMLStreamException {
        return this.reader.getElementText();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        return this.reader.nextTag();
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.reader.hasNext();
    }

    @Override
    public void close() throws XMLStreamException {
        this.reader.close();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.reader.getNamespaceURI(prefix);
    }

    @Override
    public boolean isStartElement() {
        return this.reader.isStartElement();
    }

    @Override
    public boolean isEndElement() {
        return this.reader.isEndElement();
    }

    @Override
    public boolean isCharacters() {
        return this.reader.isCharacters();
    }

    @Override
    public boolean isWhiteSpace() {
        return this.reader.isWhiteSpace();
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        return this.reader.getAttributeValue(namespaceURI, localName);
    }

    @Override
    public int getAttributeCount() {
        return this.reader.getAttributeCount();
    }

    @Override
    public QName getAttributeName(int index) {
        return this.reader.getAttributeName(index);
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.reader.getAttributeNamespace(index);
    }

    @Override
    public String getAttributeLocalName(int index) {
        return this.reader.getAttributeLocalName(index);
    }

    @Override
    public String getAttributePrefix(int index) {
        return this.reader.getAttributePrefix(index);
    }

    @Override
    public String getAttributeType(int index) {
        return this.reader.getAttributeType(index);
    }

    @Override
    public String getAttributeValue(int index) {
        return this.reader.getAttributeValue(index);
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return this.reader.isAttributeSpecified(index);
    }

    @Override
    public int getNamespaceCount() {
        return (this.depth == 1 ? this.xprefixes.length : 0) + this.reader.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int index) {
        if (this.depth == 1) {
            return index < this.xprefixes.length ? this.xprefixes[index] : this.reader.getNamespacePrefix(index - this.xprefixes.length);
        }
        return this.reader.getNamespacePrefix(index);
    }

    @Override
    public String getNamespaceURI(int index) {
        if (this.depth == 1) {
            return index < this.xprefixes.length ? this.getNamespaceURI(this.xprefixes[index]) : this.reader.getNamespaceURI(index - this.xprefixes.length);
        }
        return this.reader.getNamespaceURI(index);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.reader.getNamespaceContext();
    }

    @Override
    public int getEventType() {
        return this.reader.getEventType();
    }

    @Override
    public String getText() {
        return this.reader.getText();
    }

    @Override
    public char[] getTextCharacters() {
        return this.reader.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        return this.reader.getTextCharacters(sourceStart, target, targetStart, length);
    }

    @Override
    public int getTextStart() {
        return this.reader.getTextStart();
    }

    @Override
    public int getTextLength() {
        return this.reader.getTextLength();
    }

    @Override
    public String getEncoding() {
        return this.reader.getEncoding();
    }

    @Override
    public boolean hasText() {
        return this.reader.hasText();
    }

    @Override
    public Location getLocation() {
        return this.reader.getLocation();
    }

    @Override
    public QName getName() {
        return this.reader.getName();
    }

    @Override
    public String getLocalName() {
        return this.reader.getLocalName();
    }

    @Override
    public boolean hasName() {
        return this.reader.hasName();
    }

    @Override
    public String getNamespaceURI() {
        return this.reader.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.reader.getPrefix();
    }

    @Override
    public String getVersion() {
        return this.reader.getVersion();
    }

    @Override
    public boolean isStandalone() {
        return this.reader.isStandalone();
    }

    @Override
    public boolean standaloneSet() {
        return this.reader.standaloneSet();
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.reader.getCharacterEncodingScheme();
    }

    @Override
    public String getPITarget() {
        return this.reader.getPITarget();
    }

    @Override
    public String getPIData() {
        return this.reader.getPIData();
    }
}

