/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.server.internal;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelServerItem {
    private static final Logger LOG = LoggerFactory.getLogger(CamelServerItem.class);
    private UaObjectNode baseNode;
    private UaVariableNode item;
    private DataValue value = new DataValue(StatusCode.BAD);
    private final Set<Consumer<DataValue>> listeners = new CopyOnWriteArraySet<Consumer<DataValue>>();

    public CamelServerItem(String itemId, ServerNodeMap nodeManager, UShort namespaceIndex, UaObjectNode baseNode) {
        this.baseNode = baseNode;
        NodeId nodeId = new NodeId(namespaceIndex, "items-" + itemId);
        QualifiedName qname = new QualifiedName(namespaceIndex, itemId);
        LocalizedText displayName = LocalizedText.english((String)itemId);
        this.item = new UaVariableNode(nodeManager, nodeId, qname, displayName){

            public DataValue getValue() {
                return CamelServerItem.this.getDataValue();
            }

            public synchronized void setValue(DataValue value) {
                CamelServerItem.this.setDataValue(value);
            }
        };
        this.item.setAccessLevel(Unsigned.ubyte((int)AccessLevel.getMask((Set)AccessLevel.READ_WRITE)));
        this.item.setUserAccessLevel(Unsigned.ubyte((int)AccessLevel.getMask((Set)AccessLevel.READ_WRITE)));
        baseNode.addComponent((UaNode)this.item);
    }

    public void dispose() {
        this.baseNode.removeComponent((UaNode)this.item);
        this.listeners.clear();
    }

    public void addWriteListener(Consumer<DataValue> consumer) {
        this.listeners.add(consumer);
    }

    public void removeWriteListener(Consumer<DataValue> consumer) {
        this.listeners.remove(consumer);
    }

    protected void setDataValue(DataValue value) {
        LOG.debug("setValue -> {}", (Object)value);
        this.runThrough(this.listeners, c -> c.accept(value));
    }

    protected <T> void runThrough(Collection<Consumer<T>> list, Consumer<Consumer<T>> consumer) {
        LinkedList<Throwable> errors = null;
        for (Consumer<T> listener : list) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable e) {
                if (errors == null) {
                    errors = new LinkedList<Throwable>();
                }
                errors.add(e);
            }
        }
        if (errors == null || errors.isEmpty()) {
            return;
        }
        RuntimeException ex = new RuntimeException((Throwable)errors.pollFirst());
        errors.forEach(ex::addSuppressed);
        throw ex;
    }

    protected DataValue getDataValue() {
        return this.value;
    }

    public void update(Object value) {
        this.value = new DataValue(new Variant(value), StatusCode.GOOD, DateTime.now());
    }
}

