/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.cdi;

import javax.enterprise.inject.spi.Extension;
import org.apache.camel.cdi.CdiCamelExtension;
import org.apache.camel.test.cdi.Beans;
import org.apache.camel.test.cdi.CamelCdiContext;
import org.apache.camel.test.cdi.CamelCdiTestExtension;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

final class CamelCdiDeployment
implements TestRule {
    private final CamelCdiContext context;
    private final Weld weld;

    CamelCdiDeployment(TestClass test, CamelCdiContext context) {
        this.context = context;
        this.weld = new Weld().containerId("camel-context-cdi").property(ConfigurationKey.RELAXED_CONSTRUCTION.get(), (Object)true).property("org.jboss.weld.se.shutdownHook", (Object)false).enableDiscovery().beanClasses((Class[])test.getJavaClass().getDeclaredClasses()).addBeanClass(test.getJavaClass()).addExtension((Extension)new CdiCamelExtension());
        if (test.getJavaClass().isAnnotationPresent(Beans.class)) {
            Beans beans = test.getJavaClass().getAnnotation(Beans.class);
            this.weld.addExtension((Extension)new CamelCdiTestExtension(beans));
            for (Class<?> alternative : beans.alternatives()) {
                this.weld.addBeanClass(alternative).addAlternative(alternative);
            }
            for (Class<?> clazz : beans.classes()) {
                this.weld.addBeanClass(clazz);
            }
            this.weld.addPackages(false, (Class[])beans.packages());
        }
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                WeldContainer container = CamelCdiDeployment.this.weld.initialize();
                CamelCdiDeployment.this.context.setBeanManager(container.getBeanManager());
                try {
                    base.evaluate();
                }
                finally {
                    container.shutdown();
                    CamelCdiDeployment.this.context.unsetBeanManager();
                }
            }
        };
    }
}

