/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.util.Terser;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.spi.Language;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.util.ExpressionToPredicateAdapter;
import org.apache.camel.util.ObjectHelper;

public class TerserLanguage
implements Language {
    public static Expression terser(final String expression) {
        ObjectHelper.notNull((Object)expression, (String)"expression");
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Message message = (Message)exchange.getIn().getBody(Message.class);
                try {
                    return new Terser(message).get(expression.trim());
                }
                catch (HL7Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
                }
            }

            public String toString() {
                return "terser(" + expression + ")";
            }
        };
    }

    public Predicate createPredicate(String expression) {
        return ExpressionToPredicateAdapter.toPredicate((Expression)this.createExpression(expression));
    }

    public Expression createExpression(String expression) {
        return TerserLanguage.terser(expression);
    }
}

