/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.zipkin;

import com.github.kristofa.brave.SpanCollector;
import com.twitter.zipkin.gen.Span;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipkinLoggingSpanCollector
implements SpanCollector {
    private final String name;
    private final Logger logger;

    public ZipkinLoggingSpanCollector() {
        this(ZipkinLoggingSpanCollector.class.getName());
    }

    public ZipkinLoggingSpanCollector(String name) {
        this.name = name;
        this.logger = LoggerFactory.getLogger((String)name);
    }

    public void collect(Span span) {
        if (this.logger.isTraceEnabled()) {
            String name = span.getName();
            String traceId = "" + span.getTrace_id();
            String spanId = "" + span.getId();
            String parentId = "" + span.getParent_id();
            long ms = span.getDuration() != null ? span.getDuration() / 1000L : -1L;
            this.logger.info("Zipkin[name={}, traceId={}, spanId={}, parentId={}, duration={} ms]", new Object[]{name, traceId, spanId, parentId, ms});
        }
    }

    public void addDefaultAnnotation(String key, String value) {
    }
}

