/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.zipkin;

import com.github.kristofa.brave.ClientResponseAdapter;
import com.github.kristofa.brave.KeyValueAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.zipkin.ZipkinHelper;
import org.apache.camel.zipkin.ZipkinTracer;

public class ZipkinClientResponseAdaptor
implements ClientResponseAdapter {
    private final ZipkinTracer eventNotifier;
    private final Exchange exchange;
    private final Endpoint endpoint;
    private final String url;

    public ZipkinClientResponseAdaptor(ZipkinTracer eventNotifier, Exchange exchange, Endpoint endpoint) {
        this.eventNotifier = eventNotifier;
        this.exchange = exchange;
        this.endpoint = endpoint;
        this.url = URISupport.sanitizeUri((String)endpoint.getEndpointUri());
    }

    public Collection<KeyValueAnnotation> responseAnnotations() {
        String responseCode;
        KeyValueAnnotation key1 = KeyValueAnnotation.create((String)"camel.client.endpoint.url", (String)this.url);
        KeyValueAnnotation key2 = KeyValueAnnotation.create((String)"camel.client.exchange.id", (String)this.exchange.getExchangeId());
        KeyValueAnnotation key3 = KeyValueAnnotation.create((String)"camel.client.exchange.pattern", (String)this.exchange.getPattern().name());
        KeyValueAnnotation key4 = null;
        if (this.eventNotifier.isIncludeMessageBody() || this.eventNotifier.isIncludeMessageBodyStreams()) {
            boolean streams = this.eventNotifier.isIncludeMessageBodyStreams();
            StreamCache cache = ZipkinHelper.prepareBodyForLogging(this.exchange, streams);
            String body = MessageHelper.extractBodyForLogging((Message)(this.exchange.hasOut() ? this.exchange.getOut() : this.exchange.getIn()), (String)"", (boolean)streams, (boolean)streams);
            key4 = KeyValueAnnotation.create((String)"camel.client.exchange.message.response.body", (String)body);
            if (cache != null) {
                cache.reset();
            }
        }
        KeyValueAnnotation key5 = null;
        String string = responseCode = this.exchange.hasOut() ? (String)this.exchange.getOut().getHeader("CamelHttpResponseCode", String.class) : (String)this.exchange.getIn().getHeader("CamelHttpResponseCode", String.class);
        if (responseCode != null) {
            key5 = KeyValueAnnotation.create((String)"camel.client.exchange.message.response.code", (String)responseCode);
        }
        ArrayList<KeyValueAnnotation> list = new ArrayList<KeyValueAnnotation>();
        list.add(key1);
        list.add(key2);
        list.add(key3);
        if (key4 != null) {
            list.add(key4);
        }
        if (key5 != null) {
            list.add(key5);
        }
        return list;
    }
}

