/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.services;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesServicesProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesServicesProducer.class);

    public KubernetesServicesProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listServices": {
                this.doList(exchange, operation);
                break;
            }
            case "listServicesByLabels": {
                this.doListServiceByLabels(exchange, operation);
                break;
            }
            case "getService": {
                this.doGetService(exchange, operation);
                break;
            }
            case "createService": {
                this.doCreateService(exchange, operation);
                break;
            }
            case "deleteService": {
                this.doDeleteService(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String operation) throws Exception {
        ServiceList servicesList = null;
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        servicesList = !ObjectHelper.isEmpty((Object)namespaceName) ? (ServiceList)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().services().inNamespace(namespaceName)).list() : (ServiceList)((FilterWatchListMultiDeletable)this.getEndpoint().getKubernetesClient().services().inAnyNamespace()).list();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)servicesList.getItems());
    }

    protected void doListServiceByLabels(Exchange exchange, String operation) throws Exception {
        ServiceList servicesList = null;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesServiceLabels", Map.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (!ObjectHelper.isEmpty((Object)namespaceName)) {
            NonNamespaceOperation services = (NonNamespaceOperation)this.getEndpoint().getKubernetesClient().services().inNamespace(namespaceName);
            for (Map.Entry entry : labels.entrySet()) {
                services.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            servicesList = (ServiceList)services.list();
        } else {
            FilterWatchListMultiDeletable services = (FilterWatchListMultiDeletable)this.getEndpoint().getKubernetesClient().services().inAnyNamespace();
            for (Map.Entry entry : labels.entrySet()) {
                services.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            servicesList = (ServiceList)services.list();
        }
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)servicesList.getItems());
    }

    protected void doGetService(Exchange exchange, String operation) throws Exception {
        Service service = null;
        String serviceName = (String)exchange.getIn().getHeader("CamelKubernetesServiceName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)serviceName)) {
            LOG.error("Get a specific service require specify a service name");
            throw new IllegalArgumentException("Get a specific service require specify a service name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Get a specific service require specify a namespace name");
            throw new IllegalArgumentException("Get a specific service require specify a namespace name");
        }
        service = (Service)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().services().inNamespace(namespaceName)).withName(serviceName)).get();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)service);
    }

    protected void doCreateService(Exchange exchange, String operation) throws Exception {
        Service service = null;
        String serviceName = (String)exchange.getIn().getHeader("CamelKubernetesServiceName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        ServiceSpec serviceSpec = (ServiceSpec)exchange.getIn().getHeader("CamelKubernetesServiceSpec", ServiceSpec.class);
        if (ObjectHelper.isEmpty((Object)serviceName)) {
            LOG.error("Create a specific service require specify a service name");
            throw new IllegalArgumentException("Create a specific service require specify a service name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Create a specific service require specify a namespace name");
            throw new IllegalArgumentException("Create a specific service require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)serviceSpec)) {
            LOG.error("Create a specific service require specify a service spec bean");
            throw new IllegalArgumentException("Create a specific service require specify a service spec bean");
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesServiceLabels", Map.class);
        Service serviceCreating = ((ServiceBuilder)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(serviceName)).withLabels(labels)).endMetadata()).withSpec(serviceSpec)).build();
        service = (Service)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().services().inNamespace(namespaceName)).create((Object[])new Service[]{serviceCreating});
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)service);
    }

    protected void doDeleteService(Exchange exchange, String operation) throws Exception {
        String serviceName = (String)exchange.getIn().getHeader("CamelKubernetesServiceName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)serviceName)) {
            LOG.error("Delete a specific service require specify a service name");
            throw new IllegalArgumentException("Delete a specific service require specify a service name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Delete a specific service require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific service require specify a namespace name");
        }
        boolean serviceDeleted = (Boolean)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().services().inNamespace(namespaceName)).withName(serviceName)).delete();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)serviceDeleted);
    }
}

