/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.cloud;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceLoadBalancer;
import org.apache.camel.cloud.ServiceLoadBalancerFunction;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;

public class CamelSpringCloudServiceLoadBalancer
extends ServiceSupport
implements CamelContextAware,
ServiceLoadBalancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelSpringCloudServiceLoadBalancer.class);
    private final LoadBalancerClient loadBalancerClient;
    private CamelContext camelContext;

    public CamelSpringCloudServiceLoadBalancer(LoadBalancerClient loadBalancerClient) {
        this.loadBalancerClient = loadBalancerClient;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
        ObjectHelper.notNull((Object)this.loadBalancerClient, (String)"loadBalancerClient");
        LOGGER.info("ServiceCall is using cloud load balancer of type: {}", this.loadBalancerClient.getClass());
    }

    protected void doStop() throws Exception {
    }

    public <T> T process(String serviceName, ServiceLoadBalancerFunction<T> function) throws Exception {
        return (T)this.loadBalancerClient.execute(serviceName, i -> function.apply(this.instanceToDefinition(i)));
    }

    private ServiceDefinition instanceToDefinition(ServiceInstance instance) {
        return new DefaultServiceDefinition(instance.getServiceId(), instance.getHost(), instance.getPort(), instance.getMetadata());
    }
}

