/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.cloud;

import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.spring.boot.cloud.CamelCloudAutoConfiguration;
import org.apache.camel.spring.boot.cloud.CamelCloudConfigurationProperties;
import org.apache.camel.spring.boot.cloud.CamelCloudServiceDiscovery;
import org.apache.camel.spring.boot.cloud.CamelCloudServiceDiscoveryAutoConfiguration;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.apache.camel.spring.cloud.CamelSpringCloudDiscoveryClient;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerAutoConfiguration;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={CamelCloudAutoConfiguration.class, LoadBalancerClient.class})
@AutoConfigureAfter(value={LoadBalancerAutoConfiguration.class, CamelCloudServiceDiscoveryAutoConfiguration.class})
@EnableConfigurationProperties(value={CamelCloudConfigurationProperties.class})
@Conditional(value={LoadBalancerCondition.class})
public class CamelSpringCloudDiscoveryClientAutoConfiguration {
    @Bean(name={"load-balancer-discovery-client"})
    @ConditionalOnMissingBean
    public DiscoveryClient serviceDiscoveryClient(CamelCloudServiceDiscovery serviceDiscovery) {
        return new CamelSpringCloudDiscoveryClient("service-discovery-client", (ServiceDiscovery)serviceDiscovery);
    }

    public static class LoadBalancerCondition
    extends GroupCondition {
        public LoadBalancerCondition() {
            super("camel.cloud", "camel.cloud.discovery-client");
        }
    }
}

