/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.cloud;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.cloud.ServiceDiscovery;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class CamelSpringCloudDiscoveryClient
implements DiscoveryClient {
    private final String description;
    private final ServiceDiscovery serviceDiscovery;
    private ServiceInstance localInstance;

    public CamelSpringCloudDiscoveryClient(String description, ServiceDiscovery serviceDiscovery) {
        this(description, null, serviceDiscovery);
    }

    public CamelSpringCloudDiscoveryClient(String description, ServiceInstance localServiceDiscovery, ServiceDiscovery serviceDiscovery) {
        this.description = description;
        this.serviceDiscovery = serviceDiscovery;
        this.localInstance = localServiceDiscovery;
    }

    public String description() {
        return this.description;
    }

    public ServiceInstance getLocalServiceInstance() {
        return this.localInstance;
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        return this.serviceDiscovery.getServices(serviceId).stream().map(s -> new DefaultServiceInstance(s.getName(), s.getHost(), s.getPort(), false, s.getMetadata())).collect(Collectors.toList());
    }

    public List<String> getServices() {
        return Collections.emptyList();
    }
}

