/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.yammer;

import java.net.URLEncoder;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.yammer.YammerEndpoint;
import org.apache.camel.component.yammer.YammerFunctionType;
import org.apache.camel.component.yammer.model.Messages;
import org.apache.camel.impl.DefaultProducer;
import org.codehaus.jackson.map.ObjectMapper;

public class YammerMessageProducer
extends DefaultProducer {
    private final YammerEndpoint endpoint;
    private final String apiUrl;

    public YammerMessageProducer(YammerEndpoint endpoint) throws Exception {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.apiUrl = this.getApiUrl();
    }

    private String getApiUrl() throws Exception {
        StringBuilder url = new StringBuilder();
        String function = this.endpoint.getConfig().getFunction();
        switch (YammerFunctionType.fromUri(function)) {
            case MESSAGES: {
                url.append("https://www.yammer.com/api/v1/");
                url.append(function);
                url.append(".json");
                break;
            }
            default: {
                throw new Exception(String.format("%s is not a valid Yammer message producer function type.", function));
            }
        }
        return url.toString();
    }

    public void process(Exchange exchange) throws Exception {
        String body = (String)exchange.getIn().getBody(String.class);
        String jsonBody = this.endpoint.getConfig().getRequestor(this.apiUrl).post("?body=" + URLEncoder.encode(body, "UTF-8"));
        if (!this.endpoint.getConfig().isUseJson()) {
            ObjectMapper jsonMapper = new ObjectMapper();
            Messages messages = (Messages)jsonMapper.readValue(jsonBody, Messages.class);
            exchange.getIn().setBody((Object)messages);
        } else {
            exchange.getIn().setBody((Object)jsonBody);
        }
    }
}

