/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twilio;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.twilio.internal.TwilioApiName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class TwilioConfiguration
implements Cloneable {
    @UriPath
    @Metadata(required="true")
    private TwilioApiName apiName;
    @UriPath(enums="create,delete,fetch,read,update")
    @Metadata(required="true")
    private String methodName;
    @UriParam(label="common,security", secret=true)
    private String username;
    @UriParam(label="common,security", secret=true)
    private String password;
    @UriParam(label="common,security", secret=true)
    private String accountSid;

    public TwilioConfiguration copy() {
        try {
            return (TwilioConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public TwilioApiName getApiName() {
        return this.apiName;
    }

    public void setApiName(TwilioApiName apiName) {
        this.apiName = apiName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAccountSid() {
        return this.accountSid == null ? this.username : this.accountSid;
    }

    public void setAccountSid(String accountSid) {
        this.accountSid = accountSid;
    }
}

