/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twilio;

import com.twilio.http.TwilioRestClient;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.twilio.TwilioConfiguration;
import org.apache.camel.component.twilio.TwilioEndpoint;
import org.apache.camel.component.twilio.internal.TwilioApiCollection;
import org.apache.camel.component.twilio.internal.TwilioApiName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.component.AbstractApiComponent;
import org.apache.camel.util.component.ApiCollection;

public class TwilioComponent
extends AbstractApiComponent<TwilioApiName, TwilioConfiguration, TwilioApiCollection> {
    @Metadata(label="advanced")
    private TwilioConfiguration configuration = new TwilioConfiguration();
    @Metadata(label="advanced")
    private TwilioRestClient restClient;

    public TwilioComponent() {
        super(TwilioEndpoint.class, TwilioApiName.class, (ApiCollection)TwilioApiCollection.getCollection());
    }

    public TwilioComponent(CamelContext context) {
        super(context, TwilioEndpoint.class, TwilioApiName.class, (ApiCollection)TwilioApiCollection.getCollection());
    }

    protected TwilioApiName getApiName(String apiNameStr) throws IllegalArgumentException {
        return TwilioApiName.fromValue(apiNameStr);
    }

    protected Endpoint createEndpoint(String uri, String methodName, TwilioApiName apiName, TwilioConfiguration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        return new TwilioEndpoint(uri, this, apiName, methodName, endpointConfiguration);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.restClient == null) {
            if (this.configuration == null) {
                throw new IllegalStateException("Unable to initialise Twilio, Twilio component configuration is missing");
            }
            this.restClient = new TwilioRestClient.Builder(this.configuration.getUsername(), this.configuration.getPassword()).accountSid(this.configuration.getAccountSid()).build();
        }
    }

    public void doShutdown() throws Exception {
        this.restClient = null;
        super.doShutdown();
    }

    public TwilioConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(TwilioConfiguration configuration) {
        this.configuration = configuration;
    }

    public TwilioRestClient getRestClient() {
        return this.restClient;
    }

    public void setRestClient(TwilioRestClient restClient) {
        this.restClient = restClient;
    }
}

