/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weather.geolocation;

import org.apache.camel.component.weather.WeatherComponent;
import org.apache.camel.component.weather.geolocation.GeoLocation;
import org.apache.camel.component.weather.geolocation.GeoLocationProvider;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class FreeGeoIpGeoLocationProvider
implements GeoLocationProvider {
    private final WeatherComponent component;

    public FreeGeoIpGeoLocationProvider(WeatherComponent component) {
        this.component = component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeoLocation getCurrentGeoLocation() throws Exception {
        HttpClient httpClient = this.component.getHttpClient();
        GetMethod getMethod = new GetMethod("https://freegeoip.net/json/");
        try {
            int statusCode = httpClient.executeMethod((HttpMethod)getMethod);
            if (statusCode != 200) {
                throw new IllegalStateException("Got the unexpected http-status '" + getMethod.getStatusLine() + "' for the geolocation");
            }
            String geoLocation = (String)this.component.getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, (Object)getMethod.getResponseBodyAsStream());
            if (ObjectHelper.isEmpty((Object)geoLocation)) {
                throw new IllegalStateException("Got the unexpected value '" + geoLocation + "' for the geolocation");
            }
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = (JsonNode)mapper.readValue(geoLocation, JsonNode.class);
            JsonNode latitudeNode = (JsonNode)ObjectHelper.notNull((Object)node.get("latitude"), (String)"latitude");
            JsonNode longitudeNode = (JsonNode)ObjectHelper.notNull((Object)node.get("longitude"), (String)"longitude");
            GeoLocation geoLocation2 = new GeoLocation(longitudeNode.asText(), latitudeNode.asText());
            return geoLocation2;
        }
        finally {
            getMethod.releaseConnection();
        }
    }
}

