/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sqs;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.GetQueueUrlRequest;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.QueueAttributeName;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.sqs.NullMessageDeduplicationIdStrategy;
import org.apache.camel.component.aws.sqs.SqsComponent;
import org.apache.camel.component.aws.sqs.SqsConfiguration;
import org.apache.camel.component.aws.sqs.SqsConsumer;
import org.apache.camel.component.aws.sqs.SqsHeaderFilterStrategy;
import org.apache.camel.component.aws.sqs.SqsProducer;
import org.apache.camel.impl.DefaultScheduledPollConsumerScheduler;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.ScheduledPollConsumerScheduler;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.6.0", scheme="aws-sqs", title="AWS Simple Queue Service", syntax="aws-sqs:queueNameOrArn", consumerClass=SqsConsumer.class, label="cloud,messaging")
public class SqsEndpoint
extends ScheduledPollEndpoint
implements HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(SqsEndpoint.class);
    private AmazonSQS client;
    private String queueUrl;
    @UriPath(description="Queue name or ARN")
    @Metadata(required="true")
    private String queueNameOrArn;
    @UriParam
    private SqsConfiguration configuration;
    @UriParam(label="consumer")
    private int maxMessagesPerPoll;
    @UriParam
    private HeaderFilterStrategy headerFilterStrategy;

    public SqsEndpoint(String uri, SqsComponent component, SqsConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public Producer createProducer() throws Exception {
        return new SqsProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        SqsConsumer sqsConsumer = new SqsConsumer(this, processor);
        this.configureConsumer((Consumer)sqsConsumer);
        sqsConsumer.setMaxMessagesPerPoll(this.maxMessagesPerPoll);
        DefaultScheduledPollConsumerScheduler scheduler = new DefaultScheduledPollConsumerScheduler();
        scheduler.setConcurrentTasks(this.configuration.getConcurrentConsumers());
        sqsConsumer.setScheduler((ScheduledPollConsumerScheduler)scheduler);
        return sqsConsumer;
    }

    public boolean isSingleton() {
        return true;
    }

    protected void doStart() throws Exception {
        AmazonSQS amazonSQS = this.client = this.getConfiguration().getAmazonSQSClient() != null ? this.getConfiguration().getAmazonSQSClient() : this.getClient();
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new SqsHeaderFilterStrategy();
        }
        if (this.configuration.getRegion() != null && this.configuration.getQueueOwnerAWSAccountId() != null) {
            String host = this.configuration.getAmazonAWSHost();
            host = FileUtil.stripTrailingSeparator((String)host);
            this.queueUrl = "https://sqs." + this.configuration.getRegion() + "." + host + "/" + this.configuration.getQueueOwnerAWSAccountId() + "/" + this.configuration.getQueueName();
        } else if (this.configuration.getQueueOwnerAWSAccountId() != null) {
            GetQueueUrlRequest getQueueUrlRequest = new GetQueueUrlRequest();
            getQueueUrlRequest.setQueueName(this.configuration.getQueueName());
            getQueueUrlRequest.setQueueOwnerAWSAccountId(this.configuration.getQueueOwnerAWSAccountId());
            GetQueueUrlResult getQueueUrlResult = this.client.getQueueUrl(getQueueUrlRequest);
            this.queueUrl = getQueueUrlResult.getQueueUrl();
        } else {
            ListQueuesResult listQueuesResult = this.client.listQueues();
            for (String url : listQueuesResult.getQueueUrls()) {
                if (!url.endsWith("/" + this.configuration.getQueueName())) continue;
                this.queueUrl = url;
                LOG.trace("Queue available at '{}'.", (Object)this.queueUrl);
                break;
            }
        }
        if (this.queueUrl == null) {
            this.createQueue(this.client);
        } else {
            LOG.debug("Using Amazon SQS queue url: {}", (Object)this.queueUrl);
            this.updateQueueAttributes(this.client);
        }
    }

    protected void createQueue(AmazonSQS client) {
        LOG.trace("Queue '{}' doesn't exist. Will create it...", (Object)this.configuration.getQueueName());
        CreateQueueRequest request = new CreateQueueRequest(this.configuration.getQueueName());
        if (this.getConfiguration().isFifoQueue()) {
            request.getAttributes().put(QueueAttributeName.FifoQueue.name(), String.valueOf(true));
            boolean useContentBasedDeduplication = this.getConfiguration().getMessageDeduplicationIdStrategy() instanceof NullMessageDeduplicationIdStrategy;
            request.getAttributes().put(QueueAttributeName.ContentBasedDeduplication.name(), String.valueOf(useContentBasedDeduplication));
        }
        if (this.getConfiguration().getDefaultVisibilityTimeout() != null) {
            request.getAttributes().put(QueueAttributeName.VisibilityTimeout.name(), String.valueOf(this.getConfiguration().getDefaultVisibilityTimeout()));
        }
        if (this.getConfiguration().getMaximumMessageSize() != null) {
            request.getAttributes().put(QueueAttributeName.MaximumMessageSize.name(), String.valueOf(this.getConfiguration().getMaximumMessageSize()));
        }
        if (this.getConfiguration().getMessageRetentionPeriod() != null) {
            request.getAttributes().put(QueueAttributeName.MessageRetentionPeriod.name(), String.valueOf(this.getConfiguration().getMessageRetentionPeriod()));
        }
        if (this.getConfiguration().getPolicy() != null) {
            request.getAttributes().put(QueueAttributeName.Policy.name(), String.valueOf(this.getConfiguration().getPolicy()));
        }
        if (this.getConfiguration().getReceiveMessageWaitTimeSeconds() != null) {
            request.getAttributes().put(QueueAttributeName.ReceiveMessageWaitTimeSeconds.name(), String.valueOf(this.getConfiguration().getReceiveMessageWaitTimeSeconds()));
        }
        if (this.getConfiguration().getRedrivePolicy() != null) {
            request.getAttributes().put(QueueAttributeName.RedrivePolicy.name(), this.getConfiguration().getRedrivePolicy());
        }
        LOG.trace("Creating queue [{}] with request [{}]...", (Object)this.configuration.getQueueName(), (Object)request);
        CreateQueueResult queueResult = client.createQueue(request);
        this.queueUrl = queueResult.getQueueUrl();
        LOG.trace("Queue created and available at: {}", (Object)this.queueUrl);
    }

    private void updateQueueAttributes(AmazonSQS client) {
        SetQueueAttributesRequest request = new SetQueueAttributesRequest();
        request.setQueueUrl(this.queueUrl);
        if (this.getConfiguration().getDefaultVisibilityTimeout() != null) {
            request.getAttributes().put(QueueAttributeName.VisibilityTimeout.name(), String.valueOf(this.getConfiguration().getDefaultVisibilityTimeout()));
        }
        if (this.getConfiguration().getMaximumMessageSize() != null) {
            request.getAttributes().put(QueueAttributeName.MaximumMessageSize.name(), String.valueOf(this.getConfiguration().getMaximumMessageSize()));
        }
        if (this.getConfiguration().getMessageRetentionPeriod() != null) {
            request.getAttributes().put(QueueAttributeName.MessageRetentionPeriod.name(), String.valueOf(this.getConfiguration().getMessageRetentionPeriod()));
        }
        if (this.getConfiguration().getPolicy() != null) {
            request.getAttributes().put(QueueAttributeName.Policy.name(), String.valueOf(this.getConfiguration().getPolicy()));
        }
        if (this.getConfiguration().getReceiveMessageWaitTimeSeconds() != null) {
            request.getAttributes().put(QueueAttributeName.ReceiveMessageWaitTimeSeconds.name(), String.valueOf(this.getConfiguration().getReceiveMessageWaitTimeSeconds()));
        }
        if (this.getConfiguration().getRedrivePolicy() != null) {
            request.getAttributes().put(QueueAttributeName.RedrivePolicy.name(), this.getConfiguration().getRedrivePolicy());
        }
        if (!request.getAttributes().isEmpty()) {
            LOG.trace("Updating queue '{}' with the provided queue attributes...", (Object)this.configuration.getQueueName());
            client.setQueueAttributes(request);
            LOG.trace("Queue '{}' updated and available at {}'", (Object)this.configuration.getQueueName(), (Object)this.queueUrl);
        }
    }

    public void doStop() throws Exception {
        if (this.client != null) {
            this.client.shutdown();
        }
        super.doStop();
    }

    public Exchange createExchange(com.amazonaws.services.sqs.model.Message msg) {
        return this.createExchange(this.getExchangePattern(), msg);
    }

    private Exchange createExchange(ExchangePattern pattern, com.amazonaws.services.sqs.model.Message msg) {
        Exchange exchange = super.createExchange(pattern);
        Message message = exchange.getIn();
        message.setBody((Object)msg.getBody());
        message.setHeaders(new HashMap(msg.getAttributes()));
        message.setHeader("CamelAwsSqsMessageId", (Object)msg.getMessageId());
        message.setHeader("CamelAwsSqsMD5OfBody", (Object)msg.getMD5OfBody());
        message.setHeader("CamelAwsSqsReceiptHandle", (Object)msg.getReceiptHandle());
        message.setHeader("CamelAwsSqsAttributes", (Object)msg.getAttributes());
        message.setHeader("CamelAwsSqsMessageAttributes", (Object)msg.getMessageAttributes());
        HeaderFilterStrategy headerFilterStrategy = this.getHeaderFilterStrategy();
        for (Map.Entry entry : msg.getMessageAttributes().entrySet()) {
            Object value;
            String header = (String)entry.getKey();
            if (headerFilterStrategy.applyFilterToExternalHeaders(header, value = this.translateValue((MessageAttributeValue)entry.getValue()), exchange)) continue;
            message.setHeader(header, value);
        }
        return exchange;
    }

    public SqsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SqsConfiguration configuration) {
        this.configuration = configuration;
    }

    public AmazonSQS getClient() {
        if (this.client == null) {
            this.client = this.createClient();
        }
        return this.client;
    }

    public void setClient(AmazonSQS client) {
        this.client = client;
    }

    AmazonSQS createClient() {
        AmazonSQS client = null;
        AmazonSQSClientBuilder clientBuilder = null;
        ClientConfiguration clientConfiguration = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
            clientBuilder = isClientConfigFound ? (AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)credentialsProvider) : (AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider);
        } else {
            clientBuilder = isClientConfigFound ? AmazonSQSClientBuilder.standard() : (AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withClientConfiguration(clientConfiguration);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (AmazonSQSClientBuilder)clientBuilder.withRegion(Regions.valueOf((String)this.configuration.getRegion()));
        }
        client = (AmazonSQS)clientBuilder.build();
        return client;
    }

    protected String getQueueUrl() {
        return this.queueUrl;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    private Object translateValue(MessageAttributeValue mav) {
        Object result = null;
        if (mav.getStringValue() != null) {
            result = mav.getStringValue();
        } else if (mav.getBinaryValue() != null) {
            result = mav.getBinaryValue();
        }
        return result;
    }
}

