/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.kms;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClientBuilder;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.kms.KMSConfiguration;
import org.apache.camel.component.aws.kms.KMSProducer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.21.0", scheme="aws-kms", title="AWS KMS", syntax="aws-kms:label", producerOnly=true, label="cloud,management")
public class KMSEndpoint
extends ScheduledPollEndpoint {
    private AWSKMS kmsClient;
    @UriParam
    private KMSConfiguration configuration;

    public KMSEndpoint(String uri, Component component, KMSConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new KMSProducer((Endpoint)this);
    }

    public boolean isSingleton() {
        return true;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.kmsClient = this.configuration.getKmsClient() != null ? this.configuration.getKmsClient() : this.createKMSClient();
    }

    public void doStop() throws Exception {
        if (this.kmsClient != null) {
            this.kmsClient.shutdown();
        }
        super.doStop();
    }

    public KMSConfiguration getConfiguration() {
        return this.configuration;
    }

    public AWSKMS getKmsClient() {
        return this.kmsClient;
    }

    AWSKMS createKMSClient() {
        AWSKMS client = null;
        ClientConfiguration clientConfiguration = null;
        AWSKMSClientBuilder clientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
            clientBuilder = isClientConfigFound ? (AWSKMSClientBuilder)((AWSKMSClientBuilder)AWSKMSClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)credentialsProvider) : (AWSKMSClientBuilder)AWSKMSClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider);
        } else {
            clientBuilder = isClientConfigFound ? AWSKMSClientBuilder.standard() : (AWSKMSClientBuilder)AWSKMSClientBuilder.standard().withClientConfiguration(clientConfiguration);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (AWSKMSClientBuilder)clientBuilder.withRegion(this.configuration.getRegion());
        }
        client = (AWSKMS)clientBuilder.build();
        return client;
    }
}

