/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.cloud.netflix;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ServerList;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.cloud.ServiceFilter;
import org.apache.camel.spring.boot.cloud.CamelCloudServiceDiscovery;
import org.apache.camel.spring.boot.cloud.CamelCloudServiceFilter;
import org.apache.camel.spring.cloud.netflix.CamelCloudNetflixServerList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CamelCloudNetflixRibbonClientConfiguration {
    @Autowired
    private IClientConfig clientConfig;
    @Autowired
    private CamelCloudServiceDiscovery serviceDiscovery;
    @Autowired
    private CamelCloudServiceFilter serviceFilter;

    @Bean
    @ConditionalOnMissingBean
    public ServerList<?> ribbonServerList() {
        CamelCloudNetflixServerList serverList = new CamelCloudNetflixServerList();
        serverList.setServiceDiscovery((ServiceDiscovery)this.serviceDiscovery);
        serverList.setServiceFilter((ServiceFilter)this.serviceFilter);
        serverList.initWithNiwsConfig(this.clientConfig);
        return serverList;
    }
}

