/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mongodb.CamelMongoDbException;
import org.apache.camel.component.mongodb.MongoDbEndpoint;
import org.apache.camel.component.mongodb.MongoDbOperation;
import org.apache.camel.impl.UriEndpointComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbComponent
extends UriEndpointComponent {
    public static final Set<MongoDbOperation> WRITE_OPERATIONS = new HashSet<MongoDbOperation>(Arrays.asList(MongoDbOperation.insert, MongoDbOperation.save, MongoDbOperation.update, MongoDbOperation.remove, MongoDbOperation.bulkWrite));
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbComponent.class);

    public MongoDbComponent() {
        super(MongoDbEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MongoDbEndpoint endpoint = new MongoDbEndpoint(uri, this);
        endpoint.setConnectionBean(remaining);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
    }

    public static CamelMongoDbException wrapInCamelMongoDbException(Throwable t) {
        if (t instanceof CamelMongoDbException) {
            return (CamelMongoDbException)t;
        }
        return new CamelMongoDbException(t);
    }
}

