/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.neutron.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.common.AbstractOpenstackProducer;
import org.apache.camel.component.openstack.neutron.NeutronEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.NetworkType;
import org.openstack4j.model.network.builder.NetworkBuilder;

public class NetworkProducer
extends AbstractOpenstackProducer {
    public NetworkProducer(NeutronEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        Network in = this.messageToNetwork(exchange.getIn());
        Network out = this.os.networking().network().create(in);
        exchange.getIn().setBody((Object)out);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = (String)msg.getHeader("ID", msg.getHeader("networkId", String.class), String.class);
        ObjectHelper.notEmpty((String)id, (String)"Network ID");
        Network out = this.os.networking().network().get(id);
        exchange.getIn().setBody((Object)out);
    }

    private void doGetAll(Exchange exchange) {
        List out = this.os.networking().network().list();
        exchange.getIn().setBody((Object)out);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = (String)msg.getHeader("ID", msg.getHeader("networkId", String.class), String.class);
        ObjectHelper.notEmpty((String)id, (String)"Network ID");
        ActionResponse response = this.os.networking().network().delete(id);
        this.checkFailure(response, msg, "Delete network" + id);
    }

    private Network messageToNetwork(Message message) {
        Network network = (Network)message.getBody(Network.class);
        if (network == null) {
            Map headers = message.getHeaders();
            NetworkBuilder builder = Builders.network();
            ObjectHelper.notEmpty((String)((String)message.getHeader("name", String.class)), (String)"Name");
            builder.name((String)message.getHeader("name", String.class));
            if (headers.containsKey("adminStateUp")) {
                builder.adminStateUp(((Boolean)message.getHeader("adminStateUp", Boolean.class)).booleanValue());
            }
            if (headers.containsKey("networkType")) {
                builder.networkType((NetworkType)message.getHeader("networkType", NetworkType.class));
            }
            if (headers.containsKey("isShared")) {
                builder.isShared(((Boolean)message.getHeader("isShared", Boolean.class)).booleanValue());
            }
            if (headers.containsKey("isRouterExternal")) {
                builder.isRouterExternal(((Boolean)message.getHeader("isRouterExternal", Boolean.class)).booleanValue());
            }
            if (headers.containsKey("tenantId")) {
                builder.tenantId((String)message.getHeader("tenantId", String.class));
            }
            if (headers.containsKey("physicalNetwork")) {
                builder.physicalNetwork((String)message.getHeader("physicalNetwork", String.class));
            }
            if (headers.containsKey("segmentId")) {
                builder.segmentId((String)message.getHeader("segmentId", String.class));
            }
            network = (Network)builder.build();
        }
        return network;
    }
}

