/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.glance;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.common.AbstractOpenstackProducer;
import org.apache.camel.component.openstack.glance.GlanceEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.common.Payload;
import org.openstack4j.model.image.ContainerFormat;
import org.openstack4j.model.image.DiskFormat;
import org.openstack4j.model.image.Image;
import org.openstack4j.model.image.builder.ImageBuilder;

public class GlanceProducer
extends AbstractOpenstackProducer {
    public GlanceProducer(GlanceEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "reserve": {
                this.doReserve(exchange);
                break;
            }
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "update": {
                this.doUpdate(exchange);
                break;
            }
            case "upload": {
                this.doUpload(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doReserve(Exchange exchange) {
        Image in = this.messageToImage(exchange.getIn());
        Image out = this.os.images().reserve(in);
        exchange.getIn().setBody((Object)out);
    }

    private void doCreate(Exchange exchange) {
        Message msg = exchange.getIn();
        Image in = this.messageHeadersToImage(msg, true);
        Payload payload = this.createPayload(msg);
        Image out = this.os.images().create(in, payload);
        msg.setBody((Object)out);
    }

    private void doUpload(Exchange exchange) {
        Message msg = exchange.getIn();
        String imageId = (String)msg.getHeader("ID", String.class);
        ObjectHelper.notEmpty((String)imageId, (String)"Image ID");
        Image in = this.messageHeadersToImage(msg, false);
        Payload payload = this.createPayload(msg);
        Image out = this.os.images().upload(imageId, payload, in);
        msg.setBody((Object)out);
    }

    private void doUpdate(Exchange exchange) {
        Message msg = exchange.getIn();
        Image in = this.messageToImage(msg);
        Image out = this.os.images().update(in);
        msg.setBody((Object)out);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String imageId = (String)msg.getHeader("ID", String.class);
        ObjectHelper.notEmpty((String)imageId, (String)"ImageID");
        Image out = this.os.images().get(imageId);
        msg.setBody((Object)out);
    }

    private void doGetAll(Exchange exchange) {
        List out = this.os.images().list();
        exchange.getIn().setBody((Object)out);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String imageId = (String)msg.getHeader("ID", String.class);
        ObjectHelper.notEmpty((String)imageId, (String)"ImageID");
        ActionResponse response = this.os.compute().images().delete(imageId);
        this.checkFailure(response, msg, "Delete image " + imageId);
    }

    private Image messageToImage(Message message) {
        Image image = (Image)message.getBody(Image.class);
        if (image == null) {
            image = this.messageHeadersToImage(message, true);
        }
        return image;
    }

    private Image messageHeadersToImage(Message message, boolean required) {
        ImageBuilder imageBuilder = null;
        if (required && ObjectHelper.isEmpty((Object)message.getHeader("name", String.class))) {
            throw new IllegalArgumentException("Image Name must be specified and not empty");
        }
        if (ObjectHelper.isNotEmpty((Object)message.getHeader("name", String.class))) {
            imageBuilder = this.getImageBuilder(imageBuilder).name((String)message.getHeader("name", String.class));
        }
        if (ObjectHelper.isNotEmpty((Object)message.getHeader("diskFormat", DiskFormat.class))) {
            imageBuilder = this.getImageBuilder(imageBuilder).diskFormat((DiskFormat)message.getHeader("diskFormat", DiskFormat.class));
        }
        if (ObjectHelper.isNotEmpty((Object)message.getHeader("containerFormat", ContainerFormat.class))) {
            imageBuilder = this.getImageBuilder(imageBuilder).containerFormat((ContainerFormat)message.getHeader("containerFormat", ContainerFormat.class));
        }
        if (ObjectHelper.isNotEmpty((Object)message.getHeader("size", Long.class))) {
            imageBuilder = this.getImageBuilder(imageBuilder).size((Long)message.getHeader("size", Long.class));
        }
        if (ObjectHelper.isNotEmpty((Object)message.getHeader("checksum"))) {
            imageBuilder = this.getImageBuilder(imageBuilder).checksum((String)message.getHeader("checksum", String.class));
        }
        if (ObjectHelper.isNotEmpty((Object)message.getHeader("minDisk"))) {
            imageBuilder = this.getImageBuilder(imageBuilder).minDisk((Long)message.getHeader("minDisk", Long.class));
        }
        if (ObjectHelper.isNotEmpty((Object)message.getHeader("minRam"))) {
            imageBuilder = this.getImageBuilder(imageBuilder).minRam((Long)message.getHeader("minRam", Long.class));
        }
        if (ObjectHelper.isNotEmpty((Object)message.getHeader("owner"))) {
            imageBuilder = this.getImageBuilder(imageBuilder).owner((String)message.getHeader("owner", String.class));
        }
        if (ObjectHelper.isNotEmpty((Object)message.getHeader("isPublic"))) {
            imageBuilder = this.getImageBuilder(imageBuilder).isPublic((Boolean)message.getHeader("isPublic", Boolean.class));
        }
        if (ObjectHelper.isNotEmpty((Object)message.getHeader("properties"))) {
            imageBuilder = this.getImageBuilder(imageBuilder).properties((Map)message.getHeader("properties", Map.class));
        }
        if (!required && imageBuilder == null) {
            return null;
        }
        ObjectHelper.notNull((Object)imageBuilder, (String)"Image");
        return (Image)imageBuilder.build();
    }

    private ImageBuilder getImageBuilder(ImageBuilder builder) {
        return builder == null ? Builders.image() : builder;
    }
}

