/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.cinder.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.cinder.CinderEndpoint;
import org.apache.camel.component.openstack.common.AbstractOpenstackProducer;
import org.apache.camel.util.ObjectHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.storage.block.Volume;
import org.openstack4j.model.storage.block.builder.VolumeBuilder;

public class VolumeProducer
extends AbstractOpenstackProducer {
    public VolumeProducer(CinderEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "getAllTypes": {
                this.doGetAllTypes(exchange);
                break;
            }
            case "update": {
                this.doUpdate(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        Message msg = exchange.getIn();
        Volume in = this.messageToVolume(msg);
        Volume out = this.os.blockStorage().volumes().create(in);
        msg.setBody((Object)out);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = (String)msg.getHeader("ID", msg.getHeader("volumeId", String.class), String.class);
        ObjectHelper.notEmpty((String)id, (String)"Volume ID");
        Volume out = this.os.blockStorage().volumes().get(id);
        msg.setBody((Object)out);
    }

    private void doGetAll(Exchange exchange) {
        List out = this.os.blockStorage().volumes().list();
        exchange.getIn().setBody((Object)out);
    }

    private void doGetAllTypes(Exchange exchange) {
        List out = this.os.blockStorage().volumes().listVolumeTypes();
        exchange.getIn().setBody((Object)out);
    }

    private void doUpdate(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = (String)msg.getHeader("ID", msg.getHeader("volumeId", String.class), String.class);
        Volume vol = this.messageToVolume(msg);
        ObjectHelper.notEmpty((String)id, (String)"Cinder Volume ID");
        ObjectHelper.notEmpty((String)vol.getDescription(), (String)"Cinder Volume Description");
        ObjectHelper.notEmpty((String)vol.getName(), (String)"Cinder Volume Name");
        ActionResponse out = this.os.blockStorage().volumes().update(id, vol.getName(), vol.getDescription());
        this.checkFailure(out, msg, "Update volume " + id);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = (String)msg.getHeader("ID", msg.getHeader("volumeId", String.class), String.class);
        ObjectHelper.notEmpty((String)id, (String)"Cinder Volume ID");
        ActionResponse out = this.os.blockStorage().volumes().delete(id);
        this.checkFailure(out, msg, "Delete volume " + id);
    }

    private Volume messageToVolume(Message message) {
        Volume volume = (Volume)message.getBody(Volume.class);
        if (volume == null) {
            Map headers = message.getHeaders();
            VolumeBuilder builder = Builders.volume();
            String name = (String)message.getHeader("name", String.class);
            ObjectHelper.notEmpty((String)name, (String)"Name ");
            builder.name(name);
            if (headers.containsKey("description")) {
                builder.description((String)message.getHeader("description", String.class));
            }
            if (headers.containsKey("size")) {
                builder.size(((Integer)message.getHeader("size", Integer.class)).intValue());
            }
            if (headers.containsKey("volumeType")) {
                builder.volumeType((String)message.getHeader("volumeType", String.class));
            }
            if (headers.containsKey("imageRef")) {
                builder.imageRef((String)message.getHeader("imageRef", String.class));
            }
            if (headers.containsKey("snapshotId")) {
                builder.snapshot((String)message.getHeader("snapshotId", String.class));
            }
            if (headers.containsKey("isBootable")) {
                builder.bootable(((Boolean)message.getHeader("isBootable", Boolean.class)).booleanValue());
            }
            volume = (Volume)builder.build();
        }
        return volume;
    }
}

