/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dns.policy;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsActivation {
    private static final transient String[] DNS_TYPES = new String[]{"CNAME", "A"};
    private static final transient Logger LOG = LoggerFactory.getLogger(DnsActivation.class);
    private String hostname;
    private final List<String> resolvesTo = new ArrayList<String>();

    public DnsActivation() {
    }

    public DnsActivation(String hostname, List<String> resolvesTo) {
        this.hostname = hostname;
        this.resolvesTo.addAll(resolvesTo);
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setResolvesTo(List<String> resolvesTo) {
        this.resolvesTo.addAll(resolvesTo);
    }

    public void setResolvesTo(String resolvesTo) {
        this.resolvesTo.add(resolvesTo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        if (this.resolvesTo.isEmpty()) {
            try {
                this.resolvesTo.addAll(this.getLocalIps());
            }
            catch (Exception e) {
                LOG.warn("Failed to get local ips and resolvesTo not specified. Identifying as inactive.", (Throwable)e);
                return false;
            }
        }
        LOG.debug("Resolving " + this.hostname);
        ArrayList<String> hostnames = new ArrayList<String>();
        hostnames.add(this.hostname);
        ArrayList<String> resolved = new ArrayList<String>();
        while (!hostnames.isEmpty()) {
            NamingEnumeration<? extends Attribute> attributeEnumeration = null;
            try {
                String hostname = (String)hostnames.remove(0);
                InetAddress inetAddress = InetAddress.getByName(hostname);
                InitialDirContext initialDirContext = new InitialDirContext();
                Attributes attributes = initialDirContext.getAttributes("dns:/" + inetAddress.getHostName(), DNS_TYPES);
                attributeEnumeration = attributes.getAll();
                while (attributeEnumeration.hasMore()) {
                    Attribute attribute = attributeEnumeration.next();
                    String id = attribute.getID();
                    String value = (String)attribute.get();
                    if (this.resolvesTo.contains(value)) {
                        LOG.debug(id + " = " + value + " matched. Identifying as active.");
                        boolean bl = true;
                        return bl;
                    }
                    LOG.debug(id + " = " + value);
                    if (id.equals("CNAME") && !resolved.contains(value)) {
                        hostnames.add(value);
                    }
                    resolved.add(value);
                }
            }
            catch (Exception e) {
                LOG.warn(this.hostname, (Throwable)e);
            }
            finally {
                if (attributeEnumeration == null) continue;
                try {
                    attributeEnumeration.close();
                }
                catch (Exception e) {
                    LOG.warn("Failed to close attributeEnumeration. Memory leak possible.", (Throwable)e);
                }
                attributeEnumeration = null;
            }
        }
        return false;
    }

    private List<String> getLocalIps() throws Exception {
        ArrayList<String> localIps = new ArrayList<String>();
        Enumeration<NetworkInterface> networkInterfacesEnumeration = NetworkInterface.getNetworkInterfaces();
        while (networkInterfacesEnumeration.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfacesEnumeration.nextElement();
            Enumeration<InetAddress> inetAddressesEnumeration = networkInterface.getInetAddresses();
            while (inetAddressesEnumeration.hasMoreElements()) {
                InetAddress inetAddress = inetAddressesEnumeration.nextElement();
                String ip = inetAddress.getHostAddress();
                LOG.debug("Local ip: " + ip);
                localIps.add(ip);
            }
        }
        return localIps;
    }
}

