/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dns;

import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Type;

public class DnsLookupProducer
extends DefaultProducer {
    public DnsLookupProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        String dnsName = (String)exchange.getIn().getHeader("dns.name", String.class);
        ObjectHelper.notEmpty((String)dnsName, (String)"Header dns.name");
        Object type = exchange.getIn().getHeader("dns.type");
        Integer dnsType = null;
        if (type != null) {
            dnsType = Type.value((String)String.valueOf(type));
        }
        Object dclass = exchange.getIn().getHeader("dns.class");
        Integer dnsClass = null;
        if (dclass != null) {
            dnsClass = DClass.value((String)String.valueOf(dclass));
        }
        Lookup lookup = dnsClass == null ? (dnsType == null ? new Lookup(dnsName) : new Lookup(dnsName, dnsType.intValue())) : new Lookup(dnsName, dnsType.intValue(), dnsClass.intValue());
        lookup.run();
        if (lookup.getAnswers() == null) {
            throw new CamelException(lookup.getErrorString());
        }
        exchange.getIn().setBody((Object)lookup.getAnswers());
    }
}

